package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DescribeLoadBalancerPolicyTypesResponse(
    policyTypeDescriptions: Optional[
      Iterable[zio.aws.elasticloadbalancing.model.PolicyTypeDescription]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesResponse = {
    import DescribeLoadBalancerPolicyTypesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesResponse
      .builder()
      .optionallyWith(
        policyTypeDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policyTypeDescriptions)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesResponse.ReadOnly =
    zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesResponse
      .wrap(buildAwsValue())
}
object DescribeLoadBalancerPolicyTypesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesResponse =
      zio.aws.elasticloadbalancing.model
        .DescribeLoadBalancerPolicyTypesResponse(
          policyTypeDescriptions.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def policyTypeDescriptions: Optional[
      List[zio.aws.elasticloadbalancing.model.PolicyTypeDescription.ReadOnly]
    ]
    def getPolicyTypeDescriptions: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancing.model.PolicyTypeDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "policyTypeDescriptions",
      policyTypeDescriptions
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesResponse
  ) extends zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesResponse.ReadOnly {
    override val policyTypeDescriptions: Optional[
      List[zio.aws.elasticloadbalancing.model.PolicyTypeDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.policyTypeDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancing.model.PolicyTypeDescription.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesResponse
  ): zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesResponse.ReadOnly =
    new Wrapper(impl)
}
