package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.PolicyName
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Policies(
    appCookieStickinessPolicies: Optional[
      Iterable[zio.aws.elasticloadbalancing.model.AppCookieStickinessPolicy]
    ] = Optional.Absent,
    lbCookieStickinessPolicies: Optional[
      Iterable[zio.aws.elasticloadbalancing.model.LBCookieStickinessPolicy]
    ] = Optional.Absent,
    otherPolicies: Optional[Iterable[PolicyName]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.Policies = {
    import Policies.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.Policies
      .builder()
      .optionallyWith(
        appCookieStickinessPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.appCookieStickinessPolicies)
      .optionallyWith(
        lbCookieStickinessPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.lbCookieStickinessPolicies)
      .optionallyWith(
        otherPolicies.map(value =>
          value.map { item =>
            PolicyName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.otherPolicies)
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancing.model.Policies.ReadOnly =
    zio.aws.elasticloadbalancing.model.Policies.wrap(buildAwsValue())
}
object Policies {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.Policies
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancing.model.Policies =
      zio.aws.elasticloadbalancing.model.Policies(
        appCookieStickinessPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        lbCookieStickinessPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        otherPolicies.map(value => value)
      )
    def appCookieStickinessPolicies: Optional[List[
      zio.aws.elasticloadbalancing.model.AppCookieStickinessPolicy.ReadOnly
    ]]
    def lbCookieStickinessPolicies: Optional[
      List[zio.aws.elasticloadbalancing.model.LBCookieStickinessPolicy.ReadOnly]
    ]
    def otherPolicies: Optional[List[PolicyName]]
    def getAppCookieStickinessPolicies: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancing.model.AppCookieStickinessPolicy.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "appCookieStickinessPolicies",
      appCookieStickinessPolicies
    )
    def getLbCookieStickinessPolicies: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancing.model.LBCookieStickinessPolicy.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "lbCookieStickinessPolicies",
      lbCookieStickinessPolicies
    )
    def getOtherPolicies: ZIO[Any, AwsError, List[PolicyName]] =
      AwsError.unwrapOptionField("otherPolicies", otherPolicies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.Policies
  ) extends zio.aws.elasticloadbalancing.model.Policies.ReadOnly {
    override val appCookieStickinessPolicies: Optional[List[
      zio.aws.elasticloadbalancing.model.AppCookieStickinessPolicy.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.appCookieStickinessPolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancing.model.AppCookieStickinessPolicy
            .wrap(item)
        }.toList
      )
    override val lbCookieStickinessPolicies: Optional[
      List[zio.aws.elasticloadbalancing.model.LBCookieStickinessPolicy.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.lbCookieStickinessPolicies())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancing.model.LBCookieStickinessPolicy.wrap(item)
        }.toList
      )
    override val otherPolicies: Optional[List[PolicyName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.otherPolicies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancing.model.primitives.PolicyName(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.Policies
  ): zio.aws.elasticloadbalancing.model.Policies.ReadOnly = new Wrapper(impl)
}
