package zio.aws.elasticloadbalancing.model
import java.lang.Integer
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{
  PolicyName,
  EndPointPort,
  AccessPointName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SetLoadBalancerPoliciesForBackendServerRequest(
    loadBalancerName: AccessPointName,
    instancePort: EndPointPort,
    policyNames: Iterable[PolicyName]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest = {
    import SetLoadBalancerPoliciesForBackendServerRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest
      .builder()
      .loadBalancerName(
        AccessPointName.unwrap(loadBalancerName): java.lang.String
      )
      .instancePort(EndPointPort.unwrap(instancePort): Integer)
      .policyNames(policyNames.map { item =>
        PolicyName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest.ReadOnly =
    zio.aws.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest
      .wrap(buildAwsValue())
}
object SetLoadBalancerPoliciesForBackendServerRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest =
      zio.aws.elasticloadbalancing.model
        .SetLoadBalancerPoliciesForBackendServerRequest(
          loadBalancerName,
          instancePort,
          policyNames
        )
    def loadBalancerName: AccessPointName
    def instancePort: EndPointPort
    def policyNames: List[PolicyName]
    def getLoadBalancerName: ZIO[Any, Nothing, AccessPointName] =
      ZIO.succeed(loadBalancerName)
    def getInstancePort: ZIO[Any, Nothing, EndPointPort] =
      ZIO.succeed(instancePort)
    def getPolicyNames: ZIO[Any, Nothing, List[PolicyName]] =
      ZIO.succeed(policyNames)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest
  ) extends zio.aws.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest.ReadOnly {
    override val loadBalancerName: AccessPointName =
      zio.aws.elasticloadbalancing.model.primitives
        .AccessPointName(impl.loadBalancerName())
    override val instancePort: EndPointPort =
      zio.aws.elasticloadbalancing.model.primitives
        .EndPointPort(impl.instancePort())
    override val policyNames: List[PolicyName] = impl
      .policyNames()
      .asScala
      .map { item =>
        zio.aws.elasticloadbalancing.model.primitives.PolicyName(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest
  ): zio.aws.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest.ReadOnly =
    new Wrapper(impl)
}
