package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.AccessPointName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class AddTagsRequest(
    loadBalancerNames: Iterable[AccessPointName],
    tags: Iterable[zio.aws.elasticloadbalancing.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.AddTagsRequest = {
    import AddTagsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.AddTagsRequest
      .builder()
      .loadBalancerNames(loadBalancerNames.map { item =>
        AccessPointName.unwrap(item): java.lang.String
      }.asJavaCollection)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancing.model.AddTagsRequest.ReadOnly =
    zio.aws.elasticloadbalancing.model.AddTagsRequest.wrap(buildAwsValue())
}
object AddTagsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.AddTagsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancing.model.AddTagsRequest =
      zio.aws.elasticloadbalancing.model.AddTagsRequest(
        loadBalancerNames,
        tags.map { item =>
          item.asEditable
        }
      )
    def loadBalancerNames: List[AccessPointName]
    def tags: List[zio.aws.elasticloadbalancing.model.Tag.ReadOnly]
    def getLoadBalancerNames: ZIO[Any, Nothing, List[AccessPointName]] =
      ZIO.succeed(loadBalancerNames)
    def getTags: ZIO[Any, Nothing, List[
      zio.aws.elasticloadbalancing.model.Tag.ReadOnly
    ]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.AddTagsRequest
  ) extends zio.aws.elasticloadbalancing.model.AddTagsRequest.ReadOnly {
    override val loadBalancerNames: List[AccessPointName] = impl
      .loadBalancerNames()
      .asScala
      .map { item =>
        zio.aws.elasticloadbalancing.model.primitives.AccessPointName(item)
      }
      .toList
    override val tags: List[zio.aws.elasticloadbalancing.model.Tag.ReadOnly] =
      impl
        .tags()
        .asScala
        .map { item =>
          zio.aws.elasticloadbalancing.model.Tag.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.AddTagsRequest
  ): zio.aws.elasticloadbalancing.model.AddTagsRequest.ReadOnly = new Wrapper(
    impl
  )
}
