package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{CookieName, PolicyName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AppCookieStickinessPolicy(
    policyName: Optional[PolicyName] = Optional.Absent,
    cookieName: Optional[CookieName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.AppCookieStickinessPolicy = {
    import AppCookieStickinessPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.AppCookieStickinessPolicy
      .builder()
      .optionallyWith(
        policyName.map(value => PolicyName.unwrap(value): java.lang.String)
      )(_.policyName)
      .optionallyWith(
        cookieName.map(value => CookieName.unwrap(value): java.lang.String)
      )(_.cookieName)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.AppCookieStickinessPolicy.ReadOnly =
    zio.aws.elasticloadbalancing.model.AppCookieStickinessPolicy
      .wrap(buildAwsValue())
}
object AppCookieStickinessPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.AppCookieStickinessPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.AppCookieStickinessPolicy =
      zio.aws.elasticloadbalancing.model.AppCookieStickinessPolicy(
        policyName.map(value => value),
        cookieName.map(value => value)
      )
    def policyName: Optional[PolicyName]
    def cookieName: Optional[CookieName]
    def getPolicyName: ZIO[Any, AwsError, PolicyName] =
      AwsError.unwrapOptionField("policyName", policyName)
    def getCookieName: ZIO[Any, AwsError, CookieName] =
      AwsError.unwrapOptionField("cookieName", cookieName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.AppCookieStickinessPolicy
  ) extends zio.aws.elasticloadbalancing.model.AppCookieStickinessPolicy.ReadOnly {
    override val policyName: Optional[PolicyName] = zio.aws.core.internal
      .optionalFromNullable(impl.policyName())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.PolicyName(value)
      )
    override val cookieName: Optional[CookieName] = zio.aws.core.internal
      .optionalFromNullable(impl.cookieName())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.CookieName(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.AppCookieStickinessPolicy
  ): zio.aws.elasticloadbalancing.model.AppCookieStickinessPolicy.ReadOnly =
    new Wrapper(impl)
}
