package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{
  AdditionalAttributeValue,
  AdditionalAttributeKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AdditionalAttribute(
    key: Optional[AdditionalAttributeKey] = Optional.Absent,
    value: Optional[AdditionalAttributeValue] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.AdditionalAttribute = {
    import AdditionalAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.AdditionalAttribute
      .builder()
      .optionallyWith(
        key.map(value => AdditionalAttributeKey.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        value.map(value =>
          AdditionalAttributeValue.unwrap(value): java.lang.String
        )
      )(_.value)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.AdditionalAttribute.ReadOnly =
    zio.aws.elasticloadbalancing.model.AdditionalAttribute.wrap(buildAwsValue())
}
object AdditionalAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.AdditionalAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancing.model.AdditionalAttribute =
      zio.aws.elasticloadbalancing.model
        .AdditionalAttribute(key.map(value => value), value.map(value => value))
    def key: Optional[AdditionalAttributeKey]
    def value: Optional[AdditionalAttributeValue]
    def getKey: ZIO[Any, AwsError, AdditionalAttributeKey] =
      AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, AdditionalAttributeValue] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.AdditionalAttribute
  ) extends zio.aws.elasticloadbalancing.model.AdditionalAttribute.ReadOnly {
    override val key: Optional[AdditionalAttributeKey] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives
          .AdditionalAttributeKey(value)
      )
    override val value: Optional[AdditionalAttributeValue] =
      zio.aws.core.internal
        .optionalFromNullable(impl.value())
        .map(value =>
          zio.aws.elasticloadbalancing.model.primitives
            .AdditionalAttributeValue(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.AdditionalAttribute
  ): zio.aws.elasticloadbalancing.model.AdditionalAttribute.ReadOnly =
    new Wrapper(impl)
}
