package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{
  Description,
  ReasonCode,
  State,
  InstanceId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class InstanceState(
    instanceId: Optional[InstanceId] = Optional.Absent,
    state: Optional[State] = Optional.Absent,
    reasonCode: Optional[ReasonCode] = Optional.Absent,
    description: Optional[Description] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.InstanceState = {
    import InstanceState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.InstanceState
      .builder()
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        state.map(value => State.unwrap(value): java.lang.String)
      )(_.state)
      .optionallyWith(
        reasonCode.map(value => ReasonCode.unwrap(value): java.lang.String)
      )(_.reasonCode)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancing.model.InstanceState.ReadOnly =
    zio.aws.elasticloadbalancing.model.InstanceState.wrap(buildAwsValue())
}
object InstanceState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.InstanceState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancing.model.InstanceState =
      zio.aws.elasticloadbalancing.model.InstanceState(
        instanceId.map(value => value),
        state.map(value => value),
        reasonCode.map(value => value),
        description.map(value => value)
      )
    def instanceId: Optional[InstanceId]
    def state: Optional[State]
    def reasonCode: Optional[ReasonCode]
    def description: Optional[Description]
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getState: ZIO[Any, AwsError, State] =
      AwsError.unwrapOptionField("state", state)
    def getReasonCode: ZIO[Any, AwsError, ReasonCode] =
      AwsError.unwrapOptionField("reasonCode", reasonCode)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.InstanceState
  ) extends zio.aws.elasticloadbalancing.model.InstanceState.ReadOnly {
    override val instanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.InstanceId(value)
      )
    override val state: Optional[State] = zio.aws.core.internal
      .optionalFromNullable(impl.state())
      .map(value => zio.aws.elasticloadbalancing.model.primitives.State(value))
    override val reasonCode: Optional[ReasonCode] = zio.aws.core.internal
      .optionalFromNullable(impl.reasonCode())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.ReasonCode(value)
      )
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.Description(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.InstanceState
  ): zio.aws.elasticloadbalancing.model.InstanceState.ReadOnly = new Wrapper(
    impl
  )
}
