package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{
  CookieName,
  PolicyName,
  AccessPointName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateAppCookieStickinessPolicyRequest(
    loadBalancerName: AccessPointName,
    policyName: PolicyName,
    cookieName: CookieName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest = {
    import CreateAppCookieStickinessPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest
      .builder()
      .loadBalancerName(
        AccessPointName.unwrap(loadBalancerName): java.lang.String
      )
      .policyName(PolicyName.unwrap(policyName): java.lang.String)
      .cookieName(CookieName.unwrap(cookieName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest.ReadOnly =
    zio.aws.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest
      .wrap(buildAwsValue())
}
object CreateAppCookieStickinessPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest =
      zio.aws.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest(
        loadBalancerName,
        policyName,
        cookieName
      )
    def loadBalancerName: AccessPointName
    def policyName: PolicyName
    def cookieName: CookieName
    def getLoadBalancerName: ZIO[Any, Nothing, AccessPointName] =
      ZIO.succeed(loadBalancerName)
    def getPolicyName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(policyName)
    def getCookieName: ZIO[Any, Nothing, CookieName] = ZIO.succeed(cookieName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest
  ) extends zio.aws.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest.ReadOnly {
    override val loadBalancerName: AccessPointName =
      zio.aws.elasticloadbalancing.model.primitives
        .AccessPointName(impl.loadBalancerName())
    override val policyName: PolicyName =
      zio.aws.elasticloadbalancing.model.primitives
        .PolicyName(impl.policyName())
    override val cookieName: CookieName =
      zio.aws.elasticloadbalancing.model.primitives
        .CookieName(impl.cookieName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest
  ): zio.aws.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
