package zio.aws.elasticloadbalancing.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancing.model.primitives.{
  SubnetId,
  DNSName,
  AccessPointName,
  SecurityGroupId,
  LoadBalancerScheme,
  VPCId,
  AvailabilityZone,
  CreatedTime
}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class LoadBalancerDescription(
    loadBalancerName: Optional[AccessPointName] = Optional.Absent,
    dnsName: Optional[DNSName] = Optional.Absent,
    canonicalHostedZoneName: Optional[DNSName] = Optional.Absent,
    canonicalHostedZoneNameID: Optional[DNSName] = Optional.Absent,
    listenerDescriptions: Optional[
      Iterable[zio.aws.elasticloadbalancing.model.ListenerDescription]
    ] = Optional.Absent,
    policies: Optional[zio.aws.elasticloadbalancing.model.Policies] =
      Optional.Absent,
    backendServerDescriptions: Optional[
      Iterable[zio.aws.elasticloadbalancing.model.BackendServerDescription]
    ] = Optional.Absent,
    availabilityZones: Optional[Iterable[AvailabilityZone]] = Optional.Absent,
    subnets: Optional[Iterable[SubnetId]] = Optional.Absent,
    vpcId: Optional[VPCId] = Optional.Absent,
    instances: Optional[Iterable[zio.aws.elasticloadbalancing.model.Instance]] =
      Optional.Absent,
    healthCheck: Optional[zio.aws.elasticloadbalancing.model.HealthCheck] =
      Optional.Absent,
    sourceSecurityGroup: Optional[
      zio.aws.elasticloadbalancing.model.SourceSecurityGroup
    ] = Optional.Absent,
    securityGroups: Optional[Iterable[SecurityGroupId]] = Optional.Absent,
    createdTime: Optional[CreatedTime] = Optional.Absent,
    scheme: Optional[LoadBalancerScheme] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerDescription = {
    import LoadBalancerDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerDescription
      .builder()
      .optionallyWith(
        loadBalancerName.map(value =>
          AccessPointName.unwrap(value): java.lang.String
        )
      )(_.loadBalancerName)
      .optionallyWith(
        dnsName.map(value => DNSName.unwrap(value): java.lang.String)
      )(_.dnsName)
      .optionallyWith(
        canonicalHostedZoneName.map(value =>
          DNSName.unwrap(value): java.lang.String
        )
      )(_.canonicalHostedZoneName)
      .optionallyWith(
        canonicalHostedZoneNameID.map(value =>
          DNSName.unwrap(value): java.lang.String
        )
      )(_.canonicalHostedZoneNameID)
      .optionallyWith(
        listenerDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.listenerDescriptions)
      .optionallyWith(policies.map(value => value.buildAwsValue()))(_.policies)
      .optionallyWith(
        backendServerDescriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.backendServerDescriptions)
      .optionallyWith(
        availabilityZones.map(value =>
          value.map { item =>
            AvailabilityZone.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.availabilityZones)
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnets)
      .optionallyWith(
        vpcId.map(value => VPCId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .optionallyWith(healthCheck.map(value => value.buildAwsValue()))(
        _.healthCheck
      )
      .optionallyWith(sourceSecurityGroup.map(value => value.buildAwsValue()))(
        _.sourceSecurityGroup
      )
      .optionallyWith(
        securityGroups.map(value =>
          value.map { item =>
            SecurityGroupId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.securityGroups)
      .optionallyWith(
        createdTime.map(value => CreatedTime.unwrap(value): Instant)
      )(_.createdTime)
      .optionallyWith(
        scheme.map(value => LoadBalancerScheme.unwrap(value): java.lang.String)
      )(_.scheme)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.LoadBalancerDescription.ReadOnly =
    zio.aws.elasticloadbalancing.model.LoadBalancerDescription
      .wrap(buildAwsValue())
}
object LoadBalancerDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancing.model.LoadBalancerDescription =
      zio.aws.elasticloadbalancing.model.LoadBalancerDescription(
        loadBalancerName.map(value => value),
        dnsName.map(value => value),
        canonicalHostedZoneName.map(value => value),
        canonicalHostedZoneNameID.map(value => value),
        listenerDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        policies.map(value => value.asEditable),
        backendServerDescriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        availabilityZones.map(value => value),
        subnets.map(value => value),
        vpcId.map(value => value),
        instances.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        healthCheck.map(value => value.asEditable),
        sourceSecurityGroup.map(value => value.asEditable),
        securityGroups.map(value => value),
        createdTime.map(value => value),
        scheme.map(value => value)
      )
    def loadBalancerName: Optional[AccessPointName]
    def dnsName: Optional[DNSName]
    def canonicalHostedZoneName: Optional[DNSName]
    def canonicalHostedZoneNameID: Optional[DNSName]
    def listenerDescriptions: Optional[
      List[zio.aws.elasticloadbalancing.model.ListenerDescription.ReadOnly]
    ]
    def policies: Optional[zio.aws.elasticloadbalancing.model.Policies.ReadOnly]
    def backendServerDescriptions: Optional[
      List[zio.aws.elasticloadbalancing.model.BackendServerDescription.ReadOnly]
    ]
    def availabilityZones: Optional[List[AvailabilityZone]]
    def subnets: Optional[List[SubnetId]]
    def vpcId: Optional[VPCId]
    def instances
        : Optional[List[zio.aws.elasticloadbalancing.model.Instance.ReadOnly]]
    def healthCheck
        : Optional[zio.aws.elasticloadbalancing.model.HealthCheck.ReadOnly]
    def sourceSecurityGroup: Optional[
      zio.aws.elasticloadbalancing.model.SourceSecurityGroup.ReadOnly
    ]
    def securityGroups: Optional[List[SecurityGroupId]]
    def createdTime: Optional[CreatedTime]
    def scheme: Optional[LoadBalancerScheme]
    def getLoadBalancerName: ZIO[Any, AwsError, AccessPointName] =
      AwsError.unwrapOptionField("loadBalancerName", loadBalancerName)
    def getDnsName: ZIO[Any, AwsError, DNSName] =
      AwsError.unwrapOptionField("dnsName", dnsName)
    def getCanonicalHostedZoneName: ZIO[Any, AwsError, DNSName] = AwsError
      .unwrapOptionField("canonicalHostedZoneName", canonicalHostedZoneName)
    def getCanonicalHostedZoneNameID: ZIO[Any, AwsError, DNSName] = AwsError
      .unwrapOptionField("canonicalHostedZoneNameID", canonicalHostedZoneNameID)
    def getListenerDescriptions: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancing.model.ListenerDescription.ReadOnly
    ]] =
      AwsError.unwrapOptionField("listenerDescriptions", listenerDescriptions)
    def getPolicies: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancing.model.Policies.ReadOnly
    ] = AwsError.unwrapOptionField("policies", policies)
    def getBackendServerDescriptions: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancing.model.BackendServerDescription.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "backendServerDescriptions",
      backendServerDescriptions
    )
    def getAvailabilityZones: ZIO[Any, AwsError, List[AvailabilityZone]] =
      AwsError.unwrapOptionField("availabilityZones", availabilityZones)
    def getSubnets: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnets", subnets)
    def getVpcId: ZIO[Any, AwsError, VPCId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
    def getInstances: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancing.model.Instance.ReadOnly
    ]] = AwsError.unwrapOptionField("instances", instances)
    def getHealthCheck: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancing.model.HealthCheck.ReadOnly
    ] = AwsError.unwrapOptionField("healthCheck", healthCheck)
    def getSourceSecurityGroup: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancing.model.SourceSecurityGroup.ReadOnly
    ] = AwsError.unwrapOptionField("sourceSecurityGroup", sourceSecurityGroup)
    def getSecurityGroups: ZIO[Any, AwsError, List[SecurityGroupId]] =
      AwsError.unwrapOptionField("securityGroups", securityGroups)
    def getCreatedTime: ZIO[Any, AwsError, CreatedTime] =
      AwsError.unwrapOptionField("createdTime", createdTime)
    def getScheme: ZIO[Any, AwsError, LoadBalancerScheme] =
      AwsError.unwrapOptionField("scheme", scheme)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerDescription
  ) extends zio.aws.elasticloadbalancing.model.LoadBalancerDescription.ReadOnly {
    override val loadBalancerName: Optional[AccessPointName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loadBalancerName())
        .map(value =>
          zio.aws.elasticloadbalancing.model.primitives.AccessPointName(value)
        )
    override val dnsName: Optional[DNSName] = zio.aws.core.internal
      .optionalFromNullable(impl.dnsName())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.DNSName(value)
      )
    override val canonicalHostedZoneName: Optional[DNSName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.canonicalHostedZoneName())
        .map(value =>
          zio.aws.elasticloadbalancing.model.primitives.DNSName(value)
        )
    override val canonicalHostedZoneNameID: Optional[DNSName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.canonicalHostedZoneNameID())
        .map(value =>
          zio.aws.elasticloadbalancing.model.primitives.DNSName(value)
        )
    override val listenerDescriptions: Optional[
      List[zio.aws.elasticloadbalancing.model.ListenerDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.listenerDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancing.model.ListenerDescription.wrap(item)
        }.toList
      )
    override val policies
        : Optional[zio.aws.elasticloadbalancing.model.Policies.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policies())
        .map(value => zio.aws.elasticloadbalancing.model.Policies.wrap(value))
    override val backendServerDescriptions: Optional[
      List[zio.aws.elasticloadbalancing.model.BackendServerDescription.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.backendServerDescriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancing.model.BackendServerDescription.wrap(item)
        }.toList
      )
    override val availabilityZones: Optional[List[AvailabilityZone]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZones())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancing.model.primitives.AvailabilityZone(item)
          }.toList
        )
    override val subnets: Optional[List[SubnetId]] = zio.aws.core.internal
      .optionalFromNullable(impl.subnets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancing.model.primitives.SubnetId(item)
        }.toList
      )
    override val vpcId: Optional[VPCId] = zio.aws.core.internal
      .optionalFromNullable(impl.vpcId())
      .map(value => zio.aws.elasticloadbalancing.model.primitives.VPCId(value))
    override val instances
        : Optional[List[zio.aws.elasticloadbalancing.model.Instance.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.instances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancing.model.Instance.wrap(item)
          }.toList
        )
    override val healthCheck
        : Optional[zio.aws.elasticloadbalancing.model.HealthCheck.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.healthCheck())
        .map(value =>
          zio.aws.elasticloadbalancing.model.HealthCheck.wrap(value)
        )
    override val sourceSecurityGroup: Optional[
      zio.aws.elasticloadbalancing.model.SourceSecurityGroup.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceSecurityGroup())
      .map(value =>
        zio.aws.elasticloadbalancing.model.SourceSecurityGroup.wrap(value)
      )
    override val securityGroups: Optional[List[SecurityGroupId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.securityGroups())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancing.model.primitives.SecurityGroupId(item)
          }.toList
        )
    override val createdTime: Optional[CreatedTime] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTime())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.CreatedTime(value)
      )
    override val scheme: Optional[LoadBalancerScheme] = zio.aws.core.internal
      .optionalFromNullable(impl.scheme())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.LoadBalancerScheme(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.LoadBalancerDescription
  ): zio.aws.elasticloadbalancing.model.LoadBalancerDescription.ReadOnly =
    new Wrapper(impl)
}
