package zio.aws.elasticloadbalancing.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.elasticloadbalancing.model.primitives.{
  ConnectionDrainingTimeout,
  ConnectionDrainingEnabled
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ConnectionDraining(
    enabled: ConnectionDrainingEnabled,
    timeout: Optional[ConnectionDrainingTimeout] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.ConnectionDraining = {
    import ConnectionDraining.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.ConnectionDraining
      .builder()
      .enabled(ConnectionDrainingEnabled.unwrap(enabled): java.lang.Boolean)
      .optionallyWith(
        timeout.map(value => ConnectionDrainingTimeout.unwrap(value): Integer)
      )(_.timeout)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.ConnectionDraining.ReadOnly =
    zio.aws.elasticloadbalancing.model.ConnectionDraining.wrap(buildAwsValue())
}
object ConnectionDraining {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.ConnectionDraining
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancing.model.ConnectionDraining =
      zio.aws.elasticloadbalancing.model
        .ConnectionDraining(enabled, timeout.map(value => value))
    def enabled: ConnectionDrainingEnabled
    def timeout: Optional[ConnectionDrainingTimeout]
    def getEnabled: ZIO[Any, Nothing, ConnectionDrainingEnabled] =
      ZIO.succeed(enabled)
    def getTimeout: ZIO[Any, AwsError, ConnectionDrainingTimeout] =
      AwsError.unwrapOptionField("timeout", timeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.ConnectionDraining
  ) extends zio.aws.elasticloadbalancing.model.ConnectionDraining.ReadOnly {
    override val enabled: ConnectionDrainingEnabled =
      zio.aws.elasticloadbalancing.model.primitives
        .ConnectionDrainingEnabled(impl.enabled())
    override val timeout: Optional[ConnectionDrainingTimeout] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeout())
        .map(value =>
          zio.aws.elasticloadbalancing.model.primitives
            .ConnectionDrainingTimeout(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.ConnectionDraining
  ): zio.aws.elasticloadbalancing.model.ConnectionDraining.ReadOnly =
    new Wrapper(impl)
}
