package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.AccessPointName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ConfigureHealthCheckRequest(
    loadBalancerName: AccessPointName,
    healthCheck: zio.aws.elasticloadbalancing.model.HealthCheck
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.ConfigureHealthCheckRequest = {
    import ConfigureHealthCheckRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.ConfigureHealthCheckRequest
      .builder()
      .loadBalancerName(
        AccessPointName.unwrap(loadBalancerName): java.lang.String
      )
      .healthCheck(healthCheck.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.ConfigureHealthCheckRequest.ReadOnly =
    zio.aws.elasticloadbalancing.model.ConfigureHealthCheckRequest
      .wrap(buildAwsValue())
}
object ConfigureHealthCheckRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.ConfigureHealthCheckRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.ConfigureHealthCheckRequest =
      zio.aws.elasticloadbalancing.model
        .ConfigureHealthCheckRequest(loadBalancerName, healthCheck.asEditable)
    def loadBalancerName: AccessPointName
    def healthCheck: zio.aws.elasticloadbalancing.model.HealthCheck.ReadOnly
    def getLoadBalancerName: ZIO[Any, Nothing, AccessPointName] =
      ZIO.succeed(loadBalancerName)
    def getHealthCheck: ZIO[
      Any,
      Nothing,
      zio.aws.elasticloadbalancing.model.HealthCheck.ReadOnly
    ] = ZIO.succeed(healthCheck)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.ConfigureHealthCheckRequest
  ) extends zio.aws.elasticloadbalancing.model.ConfigureHealthCheckRequest.ReadOnly {
    override val loadBalancerName: AccessPointName =
      zio.aws.elasticloadbalancing.model.primitives
        .AccessPointName(impl.loadBalancerName())
    override val healthCheck
        : zio.aws.elasticloadbalancing.model.HealthCheck.ReadOnly =
      zio.aws.elasticloadbalancing.model.HealthCheck.wrap(impl.healthCheck())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.ConfigureHealthCheckRequest
  ): zio.aws.elasticloadbalancing.model.ConfigureHealthCheckRequest.ReadOnly =
    new Wrapper(impl)
}
