package zio.aws.elasticloadbalancing.model
import java.lang.Integer
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.IdleTimeout
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ConnectionSettings(idleTimeout: IdleTimeout) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.ConnectionSettings = {
    import ConnectionSettings.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.ConnectionSettings
      .builder()
      .idleTimeout(IdleTimeout.unwrap(idleTimeout): Integer)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.ConnectionSettings.ReadOnly =
    zio.aws.elasticloadbalancing.model.ConnectionSettings.wrap(buildAwsValue())
}
object ConnectionSettings {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.ConnectionSettings
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancing.model.ConnectionSettings =
      zio.aws.elasticloadbalancing.model.ConnectionSettings(idleTimeout)
    def idleTimeout: IdleTimeout
    def getIdleTimeout: ZIO[Any, Nothing, IdleTimeout] =
      ZIO.succeed(idleTimeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.ConnectionSettings
  ) extends zio.aws.elasticloadbalancing.model.ConnectionSettings.ReadOnly {
    override val idleTimeout: IdleTimeout =
      zio.aws.elasticloadbalancing.model.primitives
        .IdleTimeout(impl.idleTimeout())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.ConnectionSettings
  ): zio.aws.elasticloadbalancing.model.ConnectionSettings.ReadOnly =
    new Wrapper(impl)
}
