package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{
  PolicyName,
  AccessPointName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteLoadBalancerPolicyRequest(
    loadBalancerName: AccessPointName,
    policyName: PolicyName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest = {
    import DeleteLoadBalancerPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest
      .builder()
      .loadBalancerName(
        AccessPointName.unwrap(loadBalancerName): java.lang.String
      )
      .policyName(PolicyName.unwrap(policyName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest.ReadOnly =
    zio.aws.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest
      .wrap(buildAwsValue())
}
object DeleteLoadBalancerPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest =
      zio.aws.elasticloadbalancing.model
        .DeleteLoadBalancerPolicyRequest(loadBalancerName, policyName)
    def loadBalancerName: AccessPointName
    def policyName: PolicyName
    def getLoadBalancerName: ZIO[Any, Nothing, AccessPointName] =
      ZIO.succeed(loadBalancerName)
    def getPolicyName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(policyName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest
  ) extends zio.aws.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest.ReadOnly {
    override val loadBalancerName: AccessPointName =
      zio.aws.elasticloadbalancing.model.primitives
        .AccessPointName(impl.loadBalancerName())
    override val policyName: PolicyName =
      zio.aws.elasticloadbalancing.model.primitives
        .PolicyName(impl.policyName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest
  ): zio.aws.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
