package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{
  Description,
  ReasonCode,
  State,
  InstanceId
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class InstanceState(
    instanceId: Option[InstanceId] = None,
    state: Option[State] = None,
    reasonCode: Option[ReasonCode] = None,
    description: Option[Description] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.InstanceState = {
    import InstanceState.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.InstanceState
      .builder()
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(
        state.map(value => State.unwrap(value): java.lang.String)
      )(_.state)
      .optionallyWith(
        reasonCode.map(value => ReasonCode.unwrap(value): java.lang.String)
      )(_.reasonCode)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancing.model.InstanceState.ReadOnly =
    zio.aws.elasticloadbalancing.model.InstanceState.wrap(buildAwsValue())
}
object InstanceState {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.InstanceState
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancing.model.InstanceState =
      zio.aws.elasticloadbalancing.model.InstanceState(
        instanceId.map(value => value),
        state.map(value => value),
        reasonCode.map(value => value),
        description.map(value => value)
      )
    def instanceId: Option[InstanceId]
    def state: Option[State]
    def reasonCode: Option[ReasonCode]
    def description: Option[Description]
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getState: ZIO[Any, AwsError, State] =
      AwsError.unwrapOptionField("state", state)
    def getReasonCode: ZIO[Any, AwsError, ReasonCode] =
      AwsError.unwrapOptionField("reasonCode", reasonCode)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.InstanceState
  ) extends zio.aws.elasticloadbalancing.model.InstanceState.ReadOnly {
    override val instanceId: Option[InstanceId] = scala
      .Option(impl.instanceId())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.InstanceId(value)
      )
    override val state: Option[State] = scala
      .Option(impl.state())
      .map(value => zio.aws.elasticloadbalancing.model.primitives.State(value))
    override val reasonCode: Option[ReasonCode] = scala
      .Option(impl.reasonCode())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.ReasonCode(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.Description(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.InstanceState
  ): zio.aws.elasticloadbalancing.model.InstanceState.ReadOnly = new Wrapper(
    impl
  )
}
