package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.AccessPointName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class CreateLoadBalancerListenersRequest(
    loadBalancerName: AccessPointName,
    listeners: Iterable[zio.aws.elasticloadbalancing.model.Listener]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest = {
    import CreateLoadBalancerListenersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest
      .builder()
      .loadBalancerName(
        AccessPointName.unwrap(loadBalancerName): java.lang.String
      )
      .listeners(listeners.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.CreateLoadBalancerListenersRequest.ReadOnly =
    zio.aws.elasticloadbalancing.model.CreateLoadBalancerListenersRequest
      .wrap(buildAwsValue())
}
object CreateLoadBalancerListenersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.CreateLoadBalancerListenersRequest =
      zio.aws.elasticloadbalancing.model.CreateLoadBalancerListenersRequest(
        loadBalancerName,
        listeners.map { item =>
          item.asEditable
        }
      )
    def loadBalancerName: AccessPointName
    def listeners: List[zio.aws.elasticloadbalancing.model.Listener.ReadOnly]
    def getLoadBalancerName: ZIO[Any, Nothing, AccessPointName] =
      ZIO.succeed(loadBalancerName)
    def getListeners: ZIO[Any, Nothing, List[
      zio.aws.elasticloadbalancing.model.Listener.ReadOnly
    ]] = ZIO.succeed(listeners)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest
  ) extends zio.aws.elasticloadbalancing.model.CreateLoadBalancerListenersRequest.ReadOnly {
    override val loadBalancerName: AccessPointName =
      zio.aws.elasticloadbalancing.model.primitives
        .AccessPointName(impl.loadBalancerName())
    override val listeners
        : List[zio.aws.elasticloadbalancing.model.Listener.ReadOnly] = impl
      .listeners()
      .asScala
      .map { item =>
        zio.aws.elasticloadbalancing.model.Listener.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest
  ): zio.aws.elasticloadbalancing.model.CreateLoadBalancerListenersRequest.ReadOnly =
    new Wrapper(impl)
}
