package zio.aws.elasticloadbalancing
import zio.aws.elasticloadbalancing.model.LoadBalancerDescription.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.elasticloadbalancing.model.{
  DeleteLoadBalancerPolicyRequest,
  DeleteLoadBalancerListenersRequest,
  DeregisterInstancesFromLoadBalancerRequest,
  DescribeInstanceHealthRequest,
  SetLoadBalancerPoliciesForBackendServerRequest,
  ApplySecurityGroupsToLoadBalancerRequest,
  DetachLoadBalancerFromSubnetsRequest,
  AttachLoadBalancerToSubnetsRequest,
  DescribeLoadBalancerAttributesRequest,
  DisableAvailabilityZonesForLoadBalancerRequest,
  AddTagsRequest,
  CreateLoadBalancerPolicyRequest,
  CreateLoadBalancerRequest,
  ModifyLoadBalancerAttributesRequest,
  RegisterInstancesWithLoadBalancerRequest,
  DescribeTagsRequest,
  DeleteLoadBalancerRequest,
  CreateLoadBalancerListenersRequest,
  CreateLbCookieStickinessPolicyRequest,
  DescribeLoadBalancersRequest,
  SetLoadBalancerListenerSslCertificateRequest,
  DescribeAccountLimitsRequest,
  ConfigureHealthCheckRequest,
  CreateAppCookieStickinessPolicyRequest,
  SetLoadBalancerPoliciesOfListenerRequest,
  RemoveTagsRequest,
  EnableAvailabilityZonesForLoadBalancerRequest,
  DescribeLoadBalancerPoliciesRequest,
  DescribeLoadBalancerPolicyTypesRequest
}
import software.amazon.awssdk.services.elasticloadbalancing.{
  ElasticLoadBalancingAsyncClientBuilder,
  ElasticLoadBalancingAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.elasticloadbalancing.paginators.DescribeLoadBalancersPublisher
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.elasticloadbalancing.model.{
  CreateAppCookieStickinessPolicyResponse,
  LoadBalancerDescription,
  DescribeAccountLimitsResponse,
  DescribeLoadBalancersResponse,
  DeleteLoadBalancerListenersResponse,
  SetLoadBalancerPoliciesForBackendServerResponse,
  DeregisterInstancesFromLoadBalancerResponse,
  DeleteLoadBalancerPolicyResponse,
  SetLoadBalancerListenerSslCertificateResponse,
  RemoveTagsResponse,
  DeleteLoadBalancerResponse,
  DescribeLoadBalancerPoliciesResponse,
  EnableAvailabilityZonesForLoadBalancerResponse,
  ApplySecurityGroupsToLoadBalancerResponse,
  DisableAvailabilityZonesForLoadBalancerResponse,
  DetachLoadBalancerFromSubnetsResponse,
  CreateLoadBalancerResponse,
  AddTagsResponse,
  RegisterInstancesWithLoadBalancerResponse,
  CreateLoadBalancerPolicyResponse,
  DescribeInstanceHealthResponse,
  CreateLoadBalancerListenersResponse,
  AttachLoadBalancerToSubnetsResponse,
  DescribeLoadBalancerPolicyTypesResponse,
  DescribeTagsResponse,
  CreateLbCookieStickinessPolicyResponse,
  ModifyLoadBalancerAttributesResponse,
  SetLoadBalancerPoliciesOfListenerResponse,
  DescribeLoadBalancerAttributesResponse,
  ConfigureHealthCheckResponse
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait ElasticLoadBalancing extends AspectSupport[ElasticLoadBalancing] {
  val api: ElasticLoadBalancingAsyncClient
  def describeTags(request: DescribeTagsRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancing.model.DescribeTagsResponse.ReadOnly
  ]
  def createLoadBalancerListeners(
      request: CreateLoadBalancerListenersRequest
  ): IO[
    AwsError,
    zio.aws.elasticloadbalancing.model.CreateLoadBalancerListenersResponse.ReadOnly
  ]
  def createLBCookieStickinessPolicy(
      request: CreateLbCookieStickinessPolicyRequest
  ): IO[
    AwsError,
    zio.aws.elasticloadbalancing.model.CreateLbCookieStickinessPolicyResponse.ReadOnly
  ]
  def describeLoadBalancerAttributes(
      request: DescribeLoadBalancerAttributesRequest
  ): IO[
    AwsError,
    zio.aws.elasticloadbalancing.model.DescribeLoadBalancerAttributesResponse.ReadOnly
  ]
  def setLoadBalancerPoliciesForBackendServer(
      request: SetLoadBalancerPoliciesForBackendServerRequest
  ): IO[
    AwsError,
    zio.aws.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerResponse.ReadOnly
  ]
  def describeInstanceHealth(request: DescribeInstanceHealthRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancing.model.DescribeInstanceHealthResponse.ReadOnly
  ]
  def addTags(
      request: AddTagsRequest
  ): IO[AwsError, zio.aws.elasticloadbalancing.model.AddTagsResponse.ReadOnly]
  def registerInstancesWithLoadBalancer(
      request: RegisterInstancesWithLoadBalancerRequest
  ): IO[
    AwsError,
    zio.aws.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerResponse.ReadOnly
  ]
  def detachLoadBalancerFromSubnets(
      request: DetachLoadBalancerFromSubnetsRequest
  ): IO[
    AwsError,
    zio.aws.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsResponse.ReadOnly
  ]
  def describeAccountLimits(request: DescribeAccountLimitsRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancing.model.DescribeAccountLimitsResponse.ReadOnly
  ]
  def createAppCookieStickinessPolicy(
      request: CreateAppCookieStickinessPolicyRequest
  ): IO[
    AwsError,
    zio.aws.elasticloadbalancing.model.CreateAppCookieStickinessPolicyResponse.ReadOnly
  ]
  def configureHealthCheck(request: ConfigureHealthCheckRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancing.model.ConfigureHealthCheckResponse.ReadOnly
  ]
  def deleteLoadBalancer(request: DeleteLoadBalancerRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancing.model.DeleteLoadBalancerResponse.ReadOnly
  ]
  def removeTags(request: RemoveTagsRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancing.model.RemoveTagsResponse.ReadOnly
  ]
  def describeLoadBalancerPolicyTypes(
      request: DescribeLoadBalancerPolicyTypesRequest
  ): IO[
    AwsError,
    zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesResponse.ReadOnly
  ]
  def attachLoadBalancerToSubnets(
      request: AttachLoadBalancerToSubnetsRequest
  ): IO[
    AwsError,
    zio.aws.elasticloadbalancing.model.AttachLoadBalancerToSubnetsResponse.ReadOnly
  ]
  def modifyLoadBalancerAttributes(
      request: ModifyLoadBalancerAttributesRequest
  ): IO[
    AwsError,
    zio.aws.elasticloadbalancing.model.ModifyLoadBalancerAttributesResponse.ReadOnly
  ]
  def deleteLoadBalancerListeners(
      request: DeleteLoadBalancerListenersRequest
  ): IO[
    AwsError,
    zio.aws.elasticloadbalancing.model.DeleteLoadBalancerListenersResponse.ReadOnly
  ]
  def createLoadBalancerPolicy(request: CreateLoadBalancerPolicyRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancing.model.CreateLoadBalancerPolicyResponse.ReadOnly
  ]
  def describeLoadBalancerPolicies(
      request: DescribeLoadBalancerPoliciesRequest
  ): IO[
    AwsError,
    zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPoliciesResponse.ReadOnly
  ]
  def disableAvailabilityZonesForLoadBalancer(
      request: DisableAvailabilityZonesForLoadBalancerRequest
  ): IO[
    AwsError,
    zio.aws.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerResponse.ReadOnly
  ]
  def deregisterInstancesFromLoadBalancer(
      request: DeregisterInstancesFromLoadBalancerRequest
  ): IO[
    AwsError,
    zio.aws.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerResponse.ReadOnly
  ]
  def setLoadBalancerPoliciesOfListener(
      request: SetLoadBalancerPoliciesOfListenerRequest
  ): IO[
    AwsError,
    zio.aws.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerResponse.ReadOnly
  ]
  def applySecurityGroupsToLoadBalancer(
      request: ApplySecurityGroupsToLoadBalancerRequest
  ): IO[
    AwsError,
    zio.aws.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerResponse.ReadOnly
  ]
  def createLoadBalancer(request: CreateLoadBalancerRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancing.model.CreateLoadBalancerResponse.ReadOnly
  ]
  def enableAvailabilityZonesForLoadBalancer(
      request: EnableAvailabilityZonesForLoadBalancerRequest
  ): IO[
    AwsError,
    zio.aws.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerResponse.ReadOnly
  ]
  def setLoadBalancerListenerSSLCertificate(
      request: SetLoadBalancerListenerSslCertificateRequest
  ): IO[
    AwsError,
    zio.aws.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateResponse.ReadOnly
  ]
  def deleteLoadBalancerPolicy(request: DeleteLoadBalancerPolicyRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancing.model.DeleteLoadBalancerPolicyResponse.ReadOnly
  ]
  def describeLoadBalancers(
      request: DescribeLoadBalancersRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def describeLoadBalancersPaginated(request: DescribeLoadBalancersRequest): IO[
    AwsError,
    zio.aws.elasticloadbalancing.model.DescribeLoadBalancersResponse.ReadOnly
  ]
}
object ElasticLoadBalancing {
  val live: ZLayer[AwsConfig, java.lang.Throwable, ElasticLoadBalancing] =
    customized(identity)
  def customized(
      customization: ElasticLoadBalancingAsyncClientBuilder => ElasticLoadBalancingAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ElasticLoadBalancing] = managed(
    customization
  ).toLayer
  def managed(
      customization: ElasticLoadBalancingAsyncClientBuilder => ElasticLoadBalancingAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, ElasticLoadBalancing] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = ElasticLoadBalancingAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[
        ElasticLoadBalancingAsyncClient,
        ElasticLoadBalancingAsyncClientBuilder
      ](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        ElasticLoadBalancingAsyncClient,
        ElasticLoadBalancingAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new ElasticLoadBalancingImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class ElasticLoadBalancingImpl[R](
      override val api: ElasticLoadBalancingAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ElasticLoadBalancing
      with AwsServiceBase[R] {
    override val serviceName: String = "ElasticLoadBalancing"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ElasticLoadBalancingImpl[R1] =
      new ElasticLoadBalancingImpl(api, newAspect, r)
    def describeTags(request: DescribeTagsRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.DescribeTagsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.DescribeTagsRequest,
      DescribeTagsResponse
    ]("describeTags", api.describeTags)(request.buildAwsValue())
      .map(zio.aws.elasticloadbalancing.model.DescribeTagsResponse.wrap)
      .provideEnvironment(r)
    def createLoadBalancerListeners(
        request: CreateLoadBalancerListenersRequest
    ): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.CreateLoadBalancerListenersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerListenersRequest,
      CreateLoadBalancerListenersResponse
    ]("createLoadBalancerListeners", api.createLoadBalancerListeners)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticloadbalancing.model.CreateLoadBalancerListenersResponse.wrap
    ).provideEnvironment(r)
    def createLBCookieStickinessPolicy(
        request: CreateLbCookieStickinessPolicyRequest
    ): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.CreateLbCookieStickinessPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.CreateLbCookieStickinessPolicyRequest,
      CreateLbCookieStickinessPolicyResponse
    ]("createLBCookieStickinessPolicy", api.createLBCookieStickinessPolicy)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticloadbalancing.model.CreateLbCookieStickinessPolicyResponse.wrap
    ).provideEnvironment(r)
    def describeLoadBalancerAttributes(
        request: DescribeLoadBalancerAttributesRequest
    ): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.DescribeLoadBalancerAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerAttributesRequest,
      DescribeLoadBalancerAttributesResponse
    ]("describeLoadBalancerAttributes", api.describeLoadBalancerAttributes)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticloadbalancing.model.DescribeLoadBalancerAttributesResponse.wrap
    ).provideEnvironment(r)
    def setLoadBalancerPoliciesForBackendServer(
        request: SetLoadBalancerPoliciesForBackendServerRequest
    ): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerRequest,
      SetLoadBalancerPoliciesForBackendServerResponse
    ](
      "setLoadBalancerPoliciesForBackendServer",
      api.setLoadBalancerPoliciesForBackendServer
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerResponse.wrap
      )
      .provideEnvironment(r)
    def describeInstanceHealth(request: DescribeInstanceHealthRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.DescribeInstanceHealthResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.DescribeInstanceHealthRequest,
      DescribeInstanceHealthResponse
    ]("describeInstanceHealth", api.describeInstanceHealth)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticloadbalancing.model.DescribeInstanceHealthResponse.wrap
    ).provideEnvironment(r)
    def addTags(request: AddTagsRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.AddTagsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.AddTagsRequest,
      AddTagsResponse
    ]("addTags", api.addTags)(request.buildAwsValue())
      .map(zio.aws.elasticloadbalancing.model.AddTagsResponse.wrap)
      .provideEnvironment(r)
    def registerInstancesWithLoadBalancer(
        request: RegisterInstancesWithLoadBalancerRequest
    ): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerRequest,
      RegisterInstancesWithLoadBalancerResponse
    ](
      "registerInstancesWithLoadBalancer",
      api.registerInstancesWithLoadBalancer
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerResponse.wrap
      )
      .provideEnvironment(r)
    def detachLoadBalancerFromSubnets(
        request: DetachLoadBalancerFromSubnetsRequest
    ): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsRequest,
      DetachLoadBalancerFromSubnetsResponse
    ]("detachLoadBalancerFromSubnets", api.detachLoadBalancerFromSubnets)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsResponse.wrap
    ).provideEnvironment(r)
    def describeAccountLimits(request: DescribeAccountLimitsRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.DescribeAccountLimitsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.DescribeAccountLimitsRequest,
      DescribeAccountLimitsResponse
    ]("describeAccountLimits", api.describeAccountLimits)(
      request.buildAwsValue()
    ).map(zio.aws.elasticloadbalancing.model.DescribeAccountLimitsResponse.wrap)
      .provideEnvironment(r)
    def createAppCookieStickinessPolicy(
        request: CreateAppCookieStickinessPolicyRequest
    ): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.CreateAppCookieStickinessPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.CreateAppCookieStickinessPolicyRequest,
      CreateAppCookieStickinessPolicyResponse
    ]("createAppCookieStickinessPolicy", api.createAppCookieStickinessPolicy)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticloadbalancing.model.CreateAppCookieStickinessPolicyResponse.wrap
    ).provideEnvironment(r)
    def configureHealthCheck(request: ConfigureHealthCheckRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.ConfigureHealthCheckResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.ConfigureHealthCheckRequest,
      ConfigureHealthCheckResponse
    ]("configureHealthCheck", api.configureHealthCheck)(request.buildAwsValue())
      .map(zio.aws.elasticloadbalancing.model.ConfigureHealthCheckResponse.wrap)
      .provideEnvironment(r)
    def deleteLoadBalancer(request: DeleteLoadBalancerRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.DeleteLoadBalancerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerRequest,
      DeleteLoadBalancerResponse
    ]("deleteLoadBalancer", api.deleteLoadBalancer)(request.buildAwsValue())
      .map(zio.aws.elasticloadbalancing.model.DeleteLoadBalancerResponse.wrap)
      .provideEnvironment(r)
    def removeTags(request: RemoveTagsRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.RemoveTagsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.RemoveTagsRequest,
      RemoveTagsResponse
    ]("removeTags", api.removeTags)(request.buildAwsValue())
      .map(zio.aws.elasticloadbalancing.model.RemoveTagsResponse.wrap)
      .provideEnvironment(r)
    def describeLoadBalancerPolicyTypes(
        request: DescribeLoadBalancerPolicyTypesRequest
    ): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesRequest,
      DescribeLoadBalancerPolicyTypesResponse
    ]("describeLoadBalancerPolicyTypes", api.describeLoadBalancerPolicyTypes)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesResponse.wrap
    ).provideEnvironment(r)
    def attachLoadBalancerToSubnets(
        request: AttachLoadBalancerToSubnetsRequest
    ): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.AttachLoadBalancerToSubnetsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsRequest,
      AttachLoadBalancerToSubnetsResponse
    ]("attachLoadBalancerToSubnets", api.attachLoadBalancerToSubnets)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticloadbalancing.model.AttachLoadBalancerToSubnetsResponse.wrap
    ).provideEnvironment(r)
    def modifyLoadBalancerAttributes(
        request: ModifyLoadBalancerAttributesRequest
    ): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.ModifyLoadBalancerAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest,
      ModifyLoadBalancerAttributesResponse
    ]("modifyLoadBalancerAttributes", api.modifyLoadBalancerAttributes)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticloadbalancing.model.ModifyLoadBalancerAttributesResponse.wrap
    ).provideEnvironment(r)
    def deleteLoadBalancerListeners(
        request: DeleteLoadBalancerListenersRequest
    ): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.DeleteLoadBalancerListenersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerListenersRequest,
      DeleteLoadBalancerListenersResponse
    ]("deleteLoadBalancerListeners", api.deleteLoadBalancerListeners)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticloadbalancing.model.DeleteLoadBalancerListenersResponse.wrap
    ).provideEnvironment(r)
    def createLoadBalancerPolicy(request: CreateLoadBalancerPolicyRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.CreateLoadBalancerPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerPolicyRequest,
      CreateLoadBalancerPolicyResponse
    ]("createLoadBalancerPolicy", api.createLoadBalancerPolicy)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticloadbalancing.model.CreateLoadBalancerPolicyResponse.wrap
    ).provideEnvironment(r)
    def describeLoadBalancerPolicies(
        request: DescribeLoadBalancerPoliciesRequest
    ): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPoliciesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancerPoliciesRequest,
      DescribeLoadBalancerPoliciesResponse
    ]("describeLoadBalancerPolicies", api.describeLoadBalancerPolicies)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPoliciesResponse.wrap
    ).provideEnvironment(r)
    def disableAvailabilityZonesForLoadBalancer(
        request: DisableAvailabilityZonesForLoadBalancerRequest
    ): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerRequest,
      DisableAvailabilityZonesForLoadBalancerResponse
    ](
      "disableAvailabilityZonesForLoadBalancer",
      api.disableAvailabilityZonesForLoadBalancer
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerResponse.wrap
      )
      .provideEnvironment(r)
    def deregisterInstancesFromLoadBalancer(
        request: DeregisterInstancesFromLoadBalancerRequest
    ): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerRequest,
      DeregisterInstancesFromLoadBalancerResponse
    ](
      "deregisterInstancesFromLoadBalancer",
      api.deregisterInstancesFromLoadBalancer
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerResponse.wrap
      )
      .provideEnvironment(r)
    def setLoadBalancerPoliciesOfListener(
        request: SetLoadBalancerPoliciesOfListenerRequest
    ): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerRequest,
      SetLoadBalancerPoliciesOfListenerResponse
    ](
      "setLoadBalancerPoliciesOfListener",
      api.setLoadBalancerPoliciesOfListener
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerResponse.wrap
      )
      .provideEnvironment(r)
    def applySecurityGroupsToLoadBalancer(
        request: ApplySecurityGroupsToLoadBalancerRequest
    ): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerRequest,
      ApplySecurityGroupsToLoadBalancerResponse
    ](
      "applySecurityGroupsToLoadBalancer",
      api.applySecurityGroupsToLoadBalancer
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerResponse.wrap
      )
      .provideEnvironment(r)
    def createLoadBalancer(request: CreateLoadBalancerRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.CreateLoadBalancerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.CreateLoadBalancerRequest,
      CreateLoadBalancerResponse
    ]("createLoadBalancer", api.createLoadBalancer)(request.buildAwsValue())
      .map(zio.aws.elasticloadbalancing.model.CreateLoadBalancerResponse.wrap)
      .provideEnvironment(r)
    def enableAvailabilityZonesForLoadBalancer(
        request: EnableAvailabilityZonesForLoadBalancerRequest
    ): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerRequest,
      EnableAvailabilityZonesForLoadBalancerResponse
    ](
      "enableAvailabilityZonesForLoadBalancer",
      api.enableAvailabilityZonesForLoadBalancer
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerResponse.wrap
      )
      .provideEnvironment(r)
    def setLoadBalancerListenerSSLCertificate(
        request: SetLoadBalancerListenerSslCertificateRequest
    ): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateRequest,
      SetLoadBalancerListenerSslCertificateResponse
    ](
      "setLoadBalancerListenerSSLCertificate",
      api.setLoadBalancerListenerSSLCertificate
    )(request.buildAwsValue())
      .map(
        zio.aws.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateResponse.wrap
      )
      .provideEnvironment(r)
    def deleteLoadBalancerPolicy(request: DeleteLoadBalancerPolicyRequest): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.DeleteLoadBalancerPolicyResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.DeleteLoadBalancerPolicyRequest,
      DeleteLoadBalancerPolicyResponse
    ]("deleteLoadBalancerPolicy", api.deleteLoadBalancerPolicy)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticloadbalancing.model.DeleteLoadBalancerPolicyResponse.wrap
    ).provideEnvironment(r)
    def describeLoadBalancers(
        request: DescribeLoadBalancersRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersRequest,
      LoadBalancerDescription,
      DescribeLoadBalancersPublisher
    ](
      "describeLoadBalancers",
      api.describeLoadBalancersPaginator,
      _.loadBalancerDescriptions()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.elasticloadbalancing.model.LoadBalancerDescription.wrap(item)
      )
      .provideEnvironment(r)
    def describeLoadBalancersPaginated(
        request: DescribeLoadBalancersRequest
    ): IO[
      AwsError,
      zio.aws.elasticloadbalancing.model.DescribeLoadBalancersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersRequest,
      DescribeLoadBalancersResponse
    ]("describeLoadBalancers", api.describeLoadBalancers)(
      request.buildAwsValue()
    ).map(zio.aws.elasticloadbalancing.model.DescribeLoadBalancersResponse.wrap)
      .provideEnvironment(r)
  }
  def describeTags(request: DescribeTagsRequest): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.DescribeTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeTags(request))
  def createLoadBalancerListeners(
      request: CreateLoadBalancerListenersRequest
  ): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.CreateLoadBalancerListenersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLoadBalancerListeners(request))
  def createLBCookieStickinessPolicy(
      request: CreateLbCookieStickinessPolicyRequest
  ): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.CreateLbCookieStickinessPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLBCookieStickinessPolicy(request))
  def describeLoadBalancerAttributes(
      request: DescribeLoadBalancerAttributesRequest
  ): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.DescribeLoadBalancerAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLoadBalancerAttributes(request))
  def setLoadBalancerPoliciesForBackendServer(
      request: SetLoadBalancerPoliciesForBackendServerRequest
  ): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.SetLoadBalancerPoliciesForBackendServerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setLoadBalancerPoliciesForBackendServer(request))
  def describeInstanceHealth(request: DescribeInstanceHealthRequest): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.DescribeInstanceHealthResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeInstanceHealth(request))
  def addTags(request: AddTagsRequest): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.AddTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addTags(request))
  def registerInstancesWithLoadBalancer(
      request: RegisterInstancesWithLoadBalancerRequest
  ): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.registerInstancesWithLoadBalancer(request))
  def detachLoadBalancerFromSubnets(
      request: DetachLoadBalancerFromSubnetsRequest
  ): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.detachLoadBalancerFromSubnets(request))
  def describeAccountLimits(request: DescribeAccountLimitsRequest): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.DescribeAccountLimitsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAccountLimits(request))
  def createAppCookieStickinessPolicy(
      request: CreateAppCookieStickinessPolicyRequest
  ): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.CreateAppCookieStickinessPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAppCookieStickinessPolicy(request))
  def configureHealthCheck(request: ConfigureHealthCheckRequest): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.ConfigureHealthCheckResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.configureHealthCheck(request))
  def deleteLoadBalancer(request: DeleteLoadBalancerRequest): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.DeleteLoadBalancerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLoadBalancer(request))
  def removeTags(request: RemoveTagsRequest): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.RemoveTagsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeTags(request))
  def describeLoadBalancerPolicyTypes(
      request: DescribeLoadBalancerPolicyTypesRequest
  ): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPolicyTypesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLoadBalancerPolicyTypes(request))
  def attachLoadBalancerToSubnets(
      request: AttachLoadBalancerToSubnetsRequest
  ): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.AttachLoadBalancerToSubnetsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.attachLoadBalancerToSubnets(request))
  def modifyLoadBalancerAttributes(
      request: ModifyLoadBalancerAttributesRequest
  ): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.ModifyLoadBalancerAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyLoadBalancerAttributes(request))
  def deleteLoadBalancerListeners(
      request: DeleteLoadBalancerListenersRequest
  ): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.DeleteLoadBalancerListenersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLoadBalancerListeners(request))
  def createLoadBalancerPolicy(request: CreateLoadBalancerPolicyRequest): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.CreateLoadBalancerPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLoadBalancerPolicy(request))
  def describeLoadBalancerPolicies(
      request: DescribeLoadBalancerPoliciesRequest
  ): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.DescribeLoadBalancerPoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLoadBalancerPolicies(request))
  def disableAvailabilityZonesForLoadBalancer(
      request: DisableAvailabilityZonesForLoadBalancerRequest
  ): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.DisableAvailabilityZonesForLoadBalancerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.disableAvailabilityZonesForLoadBalancer(request))
  def deregisterInstancesFromLoadBalancer(
      request: DeregisterInstancesFromLoadBalancerRequest
  ): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.DeregisterInstancesFromLoadBalancerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deregisterInstancesFromLoadBalancer(request))
  def setLoadBalancerPoliciesOfListener(
      request: SetLoadBalancerPoliciesOfListenerRequest
  ): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.SetLoadBalancerPoliciesOfListenerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setLoadBalancerPoliciesOfListener(request))
  def applySecurityGroupsToLoadBalancer(
      request: ApplySecurityGroupsToLoadBalancerRequest
  ): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.ApplySecurityGroupsToLoadBalancerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.applySecurityGroupsToLoadBalancer(request))
  def createLoadBalancer(request: CreateLoadBalancerRequest): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.CreateLoadBalancerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLoadBalancer(request))
  def enableAvailabilityZonesForLoadBalancer(
      request: EnableAvailabilityZonesForLoadBalancerRequest
  ): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.EnableAvailabilityZonesForLoadBalancerResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.enableAvailabilityZonesForLoadBalancer(request))
  def setLoadBalancerListenerSSLCertificate(
      request: SetLoadBalancerListenerSslCertificateRequest
  ): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.setLoadBalancerListenerSSLCertificate(request))
  def deleteLoadBalancerPolicy(request: DeleteLoadBalancerPolicyRequest): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.DeleteLoadBalancerPolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLoadBalancerPolicy(request))
  def describeLoadBalancers(request: DescribeLoadBalancersRequest): ZStream[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    ReadOnly
  ] = ZStream.serviceWithStream(_.describeLoadBalancers(request))
  def describeLoadBalancersPaginated(
      request: DescribeLoadBalancersRequest
  ): ZIO[
    zio.aws.elasticloadbalancing.ElasticLoadBalancing,
    AwsError,
    zio.aws.elasticloadbalancing.model.DescribeLoadBalancersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeLoadBalancersPaginated(request))
}
