package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{
  AttributeType,
  AttributeName,
  Cardinality,
  DefaultValue,
  Description
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PolicyAttributeTypeDescription(
    attributeName: Option[AttributeName] = None,
    attributeType: Option[AttributeType] = None,
    description: Option[Description] = None,
    defaultValue: Option[DefaultValue] = None,
    cardinality: Option[Cardinality] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributeTypeDescription = {
    import PolicyAttributeTypeDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributeTypeDescription
      .builder()
      .optionallyWith(
        attributeName.map(value =>
          AttributeName.unwrap(value): java.lang.String
        )
      )(_.attributeName)
      .optionallyWith(
        attributeType.map(value =>
          AttributeType.unwrap(value): java.lang.String
        )
      )(_.attributeType)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        defaultValue.map(value => DefaultValue.unwrap(value): java.lang.String)
      )(_.defaultValue)
      .optionallyWith(
        cardinality.map(value => Cardinality.unwrap(value): java.lang.String)
      )(_.cardinality)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.PolicyAttributeTypeDescription.ReadOnly =
    zio.aws.elasticloadbalancing.model.PolicyAttributeTypeDescription
      .wrap(buildAwsValue())
}
object PolicyAttributeTypeDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributeTypeDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.PolicyAttributeTypeDescription =
      zio.aws.elasticloadbalancing.model.PolicyAttributeTypeDescription(
        attributeName.map(value => value),
        attributeType.map(value => value),
        description.map(value => value),
        defaultValue.map(value => value),
        cardinality.map(value => value)
      )
    def attributeName: Option[AttributeName]
    def attributeType: Option[AttributeType]
    def description: Option[Description]
    def defaultValue: Option[DefaultValue]
    def cardinality: Option[Cardinality]
    def getAttributeName: ZIO[Any, AwsError, AttributeName] =
      AwsError.unwrapOptionField("attributeName", attributeName)
    def getAttributeType: ZIO[Any, AwsError, AttributeType] =
      AwsError.unwrapOptionField("attributeType", attributeType)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getDefaultValue: ZIO[Any, AwsError, DefaultValue] =
      AwsError.unwrapOptionField("defaultValue", defaultValue)
    def getCardinality: ZIO[Any, AwsError, Cardinality] =
      AwsError.unwrapOptionField("cardinality", cardinality)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributeTypeDescription
  ) extends zio.aws.elasticloadbalancing.model.PolicyAttributeTypeDescription.ReadOnly {
    override val attributeName: Option[AttributeName] = scala
      .Option(impl.attributeName())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.AttributeName(value)
      )
    override val attributeType: Option[AttributeType] = scala
      .Option(impl.attributeType())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.AttributeType(value)
      )
    override val description: Option[Description] = scala
      .Option(impl.description())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.Description(value)
      )
    override val defaultValue: Option[DefaultValue] = scala
      .Option(impl.defaultValue())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.DefaultValue(value)
      )
    override val cardinality: Option[Cardinality] = scala
      .Option(impl.cardinality())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.Cardinality(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttributeTypeDescription
  ): zio.aws.elasticloadbalancing.model.PolicyAttributeTypeDescription.ReadOnly =
    new Wrapper(impl)
}
