package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.AccessPointName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ModifyLoadBalancerAttributesRequest(
    loadBalancerName: AccessPointName,
    loadBalancerAttributes: zio.aws.elasticloadbalancing.model.LoadBalancerAttributes
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest = {
    import ModifyLoadBalancerAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest
      .builder()
      .loadBalancerName(
        AccessPointName.unwrap(loadBalancerName): java.lang.String
      )
      .loadBalancerAttributes(loadBalancerAttributes.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest.ReadOnly =
    zio.aws.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest
      .wrap(buildAwsValue())
}
object ModifyLoadBalancerAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest =
      zio.aws.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest(
        loadBalancerName,
        loadBalancerAttributes.asEditable
      )
    def loadBalancerName: AccessPointName
    def loadBalancerAttributes
        : zio.aws.elasticloadbalancing.model.LoadBalancerAttributes.ReadOnly
    def getLoadBalancerName: ZIO[Any, Nothing, AccessPointName] =
      ZIO.succeed(loadBalancerName)
    def getLoadBalancerAttributes: ZIO[
      Any,
      Nothing,
      zio.aws.elasticloadbalancing.model.LoadBalancerAttributes.ReadOnly
    ] = ZIO.succeed(loadBalancerAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest
  ) extends zio.aws.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest.ReadOnly {
    override val loadBalancerName: AccessPointName =
      zio.aws.elasticloadbalancing.model.primitives
        .AccessPointName(impl.loadBalancerName())
    override val loadBalancerAttributes
        : zio.aws.elasticloadbalancing.model.LoadBalancerAttributes.ReadOnly =
      zio.aws.elasticloadbalancing.model.LoadBalancerAttributes
        .wrap(impl.loadBalancerAttributes())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest
  ): zio.aws.elasticloadbalancing.model.ModifyLoadBalancerAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
