package zio.aws.elasticloadbalancing.model
import java.lang.Integer
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{
  PageSize,
  Marker,
  AccessPointName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeLoadBalancersRequest(
    loadBalancerNames: Option[Iterable[AccessPointName]] = None,
    marker: Option[Marker] = None,
    pageSize: Option[PageSize] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersRequest = {
    import DescribeLoadBalancersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersRequest
      .builder()
      .optionallyWith(
        loadBalancerNames.map(value =>
          value.map { item =>
            AccessPointName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.loadBalancerNames)
      .optionallyWith(
        marker.map(value => Marker.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(pageSize.map(value => PageSize.unwrap(value): Integer))(
        _.pageSize
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.DescribeLoadBalancersRequest.ReadOnly =
    zio.aws.elasticloadbalancing.model.DescribeLoadBalancersRequest
      .wrap(buildAwsValue())
}
object DescribeLoadBalancersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.DescribeLoadBalancersRequest =
      zio.aws.elasticloadbalancing.model.DescribeLoadBalancersRequest(
        loadBalancerNames.map(value => value),
        marker.map(value => value),
        pageSize.map(value => value)
      )
    def loadBalancerNames: Option[List[AccessPointName]]
    def marker: Option[Marker]
    def pageSize: Option[PageSize]
    def getLoadBalancerNames: ZIO[Any, AwsError, List[AccessPointName]] =
      AwsError.unwrapOptionField("loadBalancerNames", loadBalancerNames)
    def getMarker: ZIO[Any, AwsError, Marker] =
      AwsError.unwrapOptionField("marker", marker)
    def getPageSize: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("pageSize", pageSize)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersRequest
  ) extends zio.aws.elasticloadbalancing.model.DescribeLoadBalancersRequest.ReadOnly {
    override val loadBalancerNames: Option[List[AccessPointName]] = scala
      .Option(impl.loadBalancerNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancing.model.primitives.AccessPointName(item)
        }.toList
      )
    override val marker: Option[Marker] = scala
      .Option(impl.marker())
      .map(value => zio.aws.elasticloadbalancing.model.primitives.Marker(value))
    override val pageSize: Option[PageSize] = scala
      .Option(impl.pageSize())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.PageSize(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DescribeLoadBalancersRequest
  ): zio.aws.elasticloadbalancing.model.DescribeLoadBalancersRequest.ReadOnly =
    new Wrapper(impl)
}
