package zio.aws.elasticloadbalancing.model
import java.lang.Integer
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{
  SSLCertificateId,
  AccessPointPort,
  AccessPointName
}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class SetLoadBalancerListenerSslCertificateRequest(
    loadBalancerName: AccessPointName,
    loadBalancerPort: AccessPointPort,
    sslCertificateId: SSLCertificateId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateRequest = {
    import SetLoadBalancerListenerSslCertificateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateRequest
      .builder()
      .loadBalancerName(
        AccessPointName.unwrap(loadBalancerName): java.lang.String
      )
      .loadBalancerPort(AccessPointPort.unwrap(loadBalancerPort): Integer)
      .sslCertificateId(
        SSLCertificateId.unwrap(sslCertificateId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateRequest.ReadOnly =
    zio.aws.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateRequest
      .wrap(buildAwsValue())
}
object SetLoadBalancerListenerSslCertificateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateRequest =
      zio.aws.elasticloadbalancing.model
        .SetLoadBalancerListenerSslCertificateRequest(
          loadBalancerName,
          loadBalancerPort,
          sslCertificateId
        )
    def loadBalancerName: AccessPointName
    def loadBalancerPort: AccessPointPort
    def sslCertificateId: SSLCertificateId
    def getLoadBalancerName: ZIO[Any, Nothing, AccessPointName] =
      ZIO.succeed(loadBalancerName)
    def getLoadBalancerPort: ZIO[Any, Nothing, AccessPointPort] =
      ZIO.succeed(loadBalancerPort)
    def getSslCertificateId: ZIO[Any, Nothing, SSLCertificateId] =
      ZIO.succeed(sslCertificateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateRequest
  ) extends zio.aws.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateRequest.ReadOnly {
    override val loadBalancerName: AccessPointName =
      zio.aws.elasticloadbalancing.model.primitives
        .AccessPointName(impl.loadBalancerName())
    override val loadBalancerPort: AccessPointPort =
      zio.aws.elasticloadbalancing.model.primitives
        .AccessPointPort(impl.loadBalancerPort())
    override val sslCertificateId: SSLCertificateId =
      zio.aws.elasticloadbalancing.model.primitives
        .SSLCertificateId(impl.sslCertificateId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateRequest
  ): zio.aws.elasticloadbalancing.model.SetLoadBalancerListenerSslCertificateRequest.ReadOnly =
    new Wrapper(impl)
}
