package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.SubnetId
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class AttachLoadBalancerToSubnetsResponse(
    subnets: Option[Iterable[SubnetId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsResponse = {
    import AttachLoadBalancerToSubnetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsResponse
      .builder()
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnets)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.AttachLoadBalancerToSubnetsResponse.ReadOnly =
    zio.aws.elasticloadbalancing.model.AttachLoadBalancerToSubnetsResponse
      .wrap(buildAwsValue())
}
object AttachLoadBalancerToSubnetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.AttachLoadBalancerToSubnetsResponse =
      zio.aws.elasticloadbalancing.model
        .AttachLoadBalancerToSubnetsResponse(subnets.map(value => value))
    def subnets: Option[List[SubnetId]]
    def getSubnets: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnets", subnets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsResponse
  ) extends zio.aws.elasticloadbalancing.model.AttachLoadBalancerToSubnetsResponse.ReadOnly {
    override val subnets: Option[List[SubnetId]] = scala
      .Option(impl.subnets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancing.model.primitives.SubnetId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.AttachLoadBalancerToSubnetsResponse
  ): zio.aws.elasticloadbalancing.model.AttachLoadBalancerToSubnetsResponse.ReadOnly =
    new Wrapper(impl)
}
