package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.AccessPointName
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class TagDescription(
    loadBalancerName: Option[AccessPointName] = None,
    tags: Option[Iterable[zio.aws.elasticloadbalancing.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.TagDescription = {
    import TagDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.TagDescription
      .builder()
      .optionallyWith(
        loadBalancerName.map(value =>
          AccessPointName.unwrap(value): java.lang.String
        )
      )(_.loadBalancerName)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancing.model.TagDescription.ReadOnly =
    zio.aws.elasticloadbalancing.model.TagDescription.wrap(buildAwsValue())
}
object TagDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.TagDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancing.model.TagDescription =
      zio.aws.elasticloadbalancing.model.TagDescription(
        loadBalancerName.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def loadBalancerName: Option[AccessPointName]
    def tags: Option[List[zio.aws.elasticloadbalancing.model.Tag.ReadOnly]]
    def getLoadBalancerName: ZIO[Any, AwsError, AccessPointName] =
      AwsError.unwrapOptionField("loadBalancerName", loadBalancerName)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancing.model.Tag.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.TagDescription
  ) extends zio.aws.elasticloadbalancing.model.TagDescription.ReadOnly {
    override val loadBalancerName: Option[AccessPointName] = scala
      .Option(impl.loadBalancerName())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.AccessPointName(value)
      )
    override val tags
        : Option[List[zio.aws.elasticloadbalancing.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancing.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.TagDescription
  ): zio.aws.elasticloadbalancing.model.TagDescription.ReadOnly = new Wrapper(
    impl
  )
}
