package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{
  AttributeValue,
  AttributeName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class PolicyAttribute(
    attributeName: Option[AttributeName] = None,
    attributeValue: Option[AttributeValue] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttribute = {
    import PolicyAttribute.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttribute
      .builder()
      .optionallyWith(
        attributeName.map(value =>
          AttributeName.unwrap(value): java.lang.String
        )
      )(_.attributeName)
      .optionallyWith(
        attributeValue.map(value =>
          AttributeValue.unwrap(value): java.lang.String
        )
      )(_.attributeValue)
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancing.model.PolicyAttribute.ReadOnly =
    zio.aws.elasticloadbalancing.model.PolicyAttribute.wrap(buildAwsValue())
}
object PolicyAttribute {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttribute
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancing.model.PolicyAttribute =
      zio.aws.elasticloadbalancing.model.PolicyAttribute(
        attributeName.map(value => value),
        attributeValue.map(value => value)
      )
    def attributeName: Option[AttributeName]
    def attributeValue: Option[AttributeValue]
    def getAttributeName: ZIO[Any, AwsError, AttributeName] =
      AwsError.unwrapOptionField("attributeName", attributeName)
    def getAttributeValue: ZIO[Any, AwsError, AttributeValue] =
      AwsError.unwrapOptionField("attributeValue", attributeValue)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttribute
  ) extends zio.aws.elasticloadbalancing.model.PolicyAttribute.ReadOnly {
    override val attributeName: Option[AttributeName] = scala
      .Option(impl.attributeName())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.AttributeName(value)
      )
    override val attributeValue: Option[AttributeValue] = scala
      .Option(impl.attributeValue())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.AttributeValue(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.PolicyAttribute
  ): zio.aws.elasticloadbalancing.model.PolicyAttribute.ReadOnly = new Wrapper(
    impl
  )
}
