package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ConfigureHealthCheckResponse(
    healthCheck: Option[zio.aws.elasticloadbalancing.model.HealthCheck] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.ConfigureHealthCheckResponse = {
    import ConfigureHealthCheckResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.ConfigureHealthCheckResponse
      .builder()
      .optionallyWith(healthCheck.map(value => value.buildAwsValue()))(
        _.healthCheck
      )
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.ConfigureHealthCheckResponse.ReadOnly =
    zio.aws.elasticloadbalancing.model.ConfigureHealthCheckResponse
      .wrap(buildAwsValue())
}
object ConfigureHealthCheckResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.ConfigureHealthCheckResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.ConfigureHealthCheckResponse =
      zio.aws.elasticloadbalancing.model.ConfigureHealthCheckResponse(
        healthCheck.map(value => value.asEditable)
      )
    def healthCheck
        : Option[zio.aws.elasticloadbalancing.model.HealthCheck.ReadOnly]
    def getHealthCheck: ZIO[
      Any,
      AwsError,
      zio.aws.elasticloadbalancing.model.HealthCheck.ReadOnly
    ] = AwsError.unwrapOptionField("healthCheck", healthCheck)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.ConfigureHealthCheckResponse
  ) extends zio.aws.elasticloadbalancing.model.ConfigureHealthCheckResponse.ReadOnly {
    override val healthCheck
        : Option[zio.aws.elasticloadbalancing.model.HealthCheck.ReadOnly] =
      scala
        .Option(impl.healthCheck())
        .map(value =>
          zio.aws.elasticloadbalancing.model.HealthCheck.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.ConfigureHealthCheckResponse
  ): zio.aws.elasticloadbalancing.model.ConfigureHealthCheckResponse.ReadOnly =
    new Wrapper(impl)
}
