package zio.aws.elasticloadbalancing.model
import java.lang.Integer
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{
  SSLCertificateId,
  InstancePort,
  AccessPointPort,
  Protocol
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class Listener(
    protocol: Protocol,
    loadBalancerPort: AccessPointPort,
    instanceProtocol: Option[Protocol] = None,
    instancePort: InstancePort,
    sslCertificateId: Option[SSLCertificateId] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.Listener = {
    import Listener.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.Listener
      .builder()
      .protocol(Protocol.unwrap(protocol): java.lang.String)
      .loadBalancerPort(AccessPointPort.unwrap(loadBalancerPort): Integer)
      .optionallyWith(
        instanceProtocol.map(value => Protocol.unwrap(value): java.lang.String)
      )(_.instanceProtocol)
      .instancePort(InstancePort.unwrap(instancePort): Integer)
      .optionallyWith(
        sslCertificateId.map(value =>
          SSLCertificateId.unwrap(value): java.lang.String
        )
      )(_.sslCertificateId)
      .build()
  }
  def asReadOnly: zio.aws.elasticloadbalancing.model.Listener.ReadOnly =
    zio.aws.elasticloadbalancing.model.Listener.wrap(buildAwsValue())
}
object Listener {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.Listener
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticloadbalancing.model.Listener =
      zio.aws.elasticloadbalancing.model.Listener(
        protocol,
        loadBalancerPort,
        instanceProtocol.map(value => value),
        instancePort,
        sslCertificateId.map(value => value)
      )
    def protocol: Protocol
    def loadBalancerPort: AccessPointPort
    def instanceProtocol: Option[Protocol]
    def instancePort: InstancePort
    def sslCertificateId: Option[SSLCertificateId]
    def getProtocol: ZIO[Any, Nothing, Protocol] = ZIO.succeed(protocol)
    def getLoadBalancerPort: ZIO[Any, Nothing, AccessPointPort] =
      ZIO.succeed(loadBalancerPort)
    def getInstanceProtocol: ZIO[Any, AwsError, Protocol] =
      AwsError.unwrapOptionField("instanceProtocol", instanceProtocol)
    def getInstancePort: ZIO[Any, Nothing, InstancePort] =
      ZIO.succeed(instancePort)
    def getSslCertificateId: ZIO[Any, AwsError, SSLCertificateId] =
      AwsError.unwrapOptionField("sslCertificateId", sslCertificateId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.Listener
  ) extends zio.aws.elasticloadbalancing.model.Listener.ReadOnly {
    override val protocol: Protocol =
      zio.aws.elasticloadbalancing.model.primitives.Protocol(impl.protocol())
    override val loadBalancerPort: AccessPointPort =
      zio.aws.elasticloadbalancing.model.primitives
        .AccessPointPort(impl.loadBalancerPort())
    override val instanceProtocol: Option[Protocol] = scala
      .Option(impl.instanceProtocol())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.Protocol(value)
      )
    override val instancePort: InstancePort =
      zio.aws.elasticloadbalancing.model.primitives
        .InstancePort(impl.instancePort())
    override val sslCertificateId: Option[SSLCertificateId] = scala
      .Option(impl.sslCertificateId())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives.SSLCertificateId(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.Listener
  ): zio.aws.elasticloadbalancing.model.Listener.ReadOnly = new Wrapper(impl)
}
