package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.{
  CookieExpirationPeriod,
  PolicyName,
  AccessPointName
}
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class CreateLbCookieStickinessPolicyRequest(
    loadBalancerName: AccessPointName,
    policyName: PolicyName,
    cookieExpirationPeriod: Option[CookieExpirationPeriod] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.CreateLbCookieStickinessPolicyRequest = {
    import CreateLbCookieStickinessPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.CreateLbCookieStickinessPolicyRequest
      .builder()
      .loadBalancerName(
        AccessPointName.unwrap(loadBalancerName): java.lang.String
      )
      .policyName(PolicyName.unwrap(policyName): java.lang.String)
      .optionallyWith(
        cookieExpirationPeriod.map(value =>
          CookieExpirationPeriod.unwrap(value): java.lang.Long
        )
      )(_.cookieExpirationPeriod)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.CreateLbCookieStickinessPolicyRequest.ReadOnly =
    zio.aws.elasticloadbalancing.model.CreateLbCookieStickinessPolicyRequest
      .wrap(buildAwsValue())
}
object CreateLbCookieStickinessPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.CreateLbCookieStickinessPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.CreateLbCookieStickinessPolicyRequest =
      zio.aws.elasticloadbalancing.model.CreateLbCookieStickinessPolicyRequest(
        loadBalancerName,
        policyName,
        cookieExpirationPeriod.map(value => value)
      )
    def loadBalancerName: AccessPointName
    def policyName: PolicyName
    def cookieExpirationPeriod: Option[CookieExpirationPeriod]
    def getLoadBalancerName: ZIO[Any, Nothing, AccessPointName] =
      ZIO.succeed(loadBalancerName)
    def getPolicyName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(policyName)
    def getCookieExpirationPeriod: ZIO[Any, AwsError, CookieExpirationPeriod] =
      AwsError.unwrapOptionField(
        "cookieExpirationPeriod",
        cookieExpirationPeriod
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.CreateLbCookieStickinessPolicyRequest
  ) extends zio.aws.elasticloadbalancing.model.CreateLbCookieStickinessPolicyRequest.ReadOnly {
    override val loadBalancerName: AccessPointName =
      zio.aws.elasticloadbalancing.model.primitives
        .AccessPointName(impl.loadBalancerName())
    override val policyName: PolicyName =
      zio.aws.elasticloadbalancing.model.primitives
        .PolicyName(impl.policyName())
    override val cookieExpirationPeriod: Option[CookieExpirationPeriod] = scala
      .Option(impl.cookieExpirationPeriod())
      .map(value =>
        zio.aws.elasticloadbalancing.model.primitives
          .CookieExpirationPeriod(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.CreateLbCookieStickinessPolicyRequest
  ): zio.aws.elasticloadbalancing.model.CreateLbCookieStickinessPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
