package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class RegisterInstancesWithLoadBalancerResponse(
    instances: Option[Iterable[zio.aws.elasticloadbalancing.model.Instance]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerResponse = {
    import RegisterInstancesWithLoadBalancerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerResponse
      .builder()
      .optionallyWith(
        instances.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.instances)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerResponse.ReadOnly =
    zio.aws.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerResponse
      .wrap(buildAwsValue())
}
object RegisterInstancesWithLoadBalancerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerResponse =
      zio.aws.elasticloadbalancing.model
        .RegisterInstancesWithLoadBalancerResponse(
          instances.map(value =>
            value.map { item =>
              item.asEditable
            }
          )
        )
    def instances
        : Option[List[zio.aws.elasticloadbalancing.model.Instance.ReadOnly]]
    def getInstances: ZIO[Any, AwsError, List[
      zio.aws.elasticloadbalancing.model.Instance.ReadOnly
    ]] = AwsError.unwrapOptionField("instances", instances)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerResponse
  ) extends zio.aws.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerResponse.ReadOnly {
    override val instances
        : Option[List[zio.aws.elasticloadbalancing.model.Instance.ReadOnly]] =
      scala
        .Option(impl.instances())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticloadbalancing.model.Instance.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerResponse
  ): zio.aws.elasticloadbalancing.model.RegisterInstancesWithLoadBalancerResponse.ReadOnly =
    new Wrapper(impl)
}
