package zio.aws.elasticloadbalancing.model
import zio.ZIO
import zio.aws.elasticloadbalancing.model.primitives.SubnetId
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DetachLoadBalancerFromSubnetsResponse(
    subnets: Option[Iterable[SubnetId]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsResponse = {
    import DetachLoadBalancerFromSubnetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsResponse
      .builder()
      .optionallyWith(
        subnets.map(value =>
          value.map { item =>
            SubnetId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.subnets)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsResponse.ReadOnly =
    zio.aws.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsResponse
      .wrap(buildAwsValue())
}
object DetachLoadBalancerFromSubnetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsResponse =
      zio.aws.elasticloadbalancing.model
        .DetachLoadBalancerFromSubnetsResponse(subnets.map(value => value))
    def subnets: Option[List[SubnetId]]
    def getSubnets: ZIO[Any, AwsError, List[SubnetId]] =
      AwsError.unwrapOptionField("subnets", subnets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsResponse
  ) extends zio.aws.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsResponse.ReadOnly {
    override val subnets: Option[List[SubnetId]] = scala
      .Option(impl.subnets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticloadbalancing.model.primitives.SubnetId(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsResponse
  ): zio.aws.elasticloadbalancing.model.DetachLoadBalancerFromSubnetsResponse.ReadOnly =
    new Wrapper(impl)
}
