package zio.aws.elasticinference.model
import zio.aws.elasticinference.model.primitives.AcceleratorHealthStatus
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ElasticInferenceAcceleratorHealth(
    status: Option[AcceleratorHealthStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticinference.model.ElasticInferenceAcceleratorHealth = {
    import ElasticInferenceAcceleratorHealth.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticinference.model.ElasticInferenceAcceleratorHealth
      .builder()
      .optionallyWith(
        status.map(value =>
          AcceleratorHealthStatus.unwrap(value): java.lang.String
        )
      )(_.status)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticinference.model.ElasticInferenceAcceleratorHealth.ReadOnly =
    zio.aws.elasticinference.model.ElasticInferenceAcceleratorHealth
      .wrap(buildAwsValue())
}
object ElasticInferenceAcceleratorHealth {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticinference.model.ElasticInferenceAcceleratorHealth
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticinference.model.ElasticInferenceAcceleratorHealth =
      zio.aws.elasticinference.model
        .ElasticInferenceAcceleratorHealth(status.map(value => value))
    def status: Option[AcceleratorHealthStatus]
    def getStatus: ZIO[Any, AwsError, AcceleratorHealthStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticinference.model.ElasticInferenceAcceleratorHealth
  ) extends zio.aws.elasticinference.model.ElasticInferenceAcceleratorHealth.ReadOnly {
    override val status: Option[AcceleratorHealthStatus] = scala
      .Option(impl.status())
      .map(value =>
        zio.aws.elasticinference.model.primitives.AcceleratorHealthStatus(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticinference.model.ElasticInferenceAcceleratorHealth
  ): zio.aws.elasticinference.model.ElasticInferenceAcceleratorHealth.ReadOnly =
    new Wrapper(impl)
}
