package zio.aws.elasticinference.model
import zio.aws.elasticinference.model.primitives.{Location, AcceleratorTypeName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class AcceleratorTypeOffering(
    acceleratorType: Option[AcceleratorTypeName] = None,
    locationType: Option[zio.aws.elasticinference.model.LocationType] = None,
    location: Option[Location] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticinference.model.AcceleratorTypeOffering = {
    import AcceleratorTypeOffering.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticinference.model.AcceleratorTypeOffering
      .builder()
      .optionallyWith(
        acceleratorType.map(value =>
          AcceleratorTypeName.unwrap(value): java.lang.String
        )
      )(_.acceleratorType)
      .optionallyWith(locationType.map(value => value.unwrap))(_.locationType)
      .optionallyWith(
        location.map(value => Location.unwrap(value): java.lang.String)
      )(_.location)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticinference.model.AcceleratorTypeOffering.ReadOnly =
    zio.aws.elasticinference.model.AcceleratorTypeOffering.wrap(buildAwsValue())
}
object AcceleratorTypeOffering {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticinference.model.AcceleratorTypeOffering
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticinference.model.AcceleratorTypeOffering =
      zio.aws.elasticinference.model.AcceleratorTypeOffering(
        acceleratorType.map(value => value),
        locationType.map(value => value),
        location.map(value => value)
      )
    def acceleratorType: Option[AcceleratorTypeName]
    def locationType: Option[zio.aws.elasticinference.model.LocationType]
    def location: Option[Location]
    def getAcceleratorType: ZIO[Any, AwsError, AcceleratorTypeName] =
      AwsError.unwrapOptionField("acceleratorType", acceleratorType)
    def getLocationType
        : ZIO[Any, AwsError, zio.aws.elasticinference.model.LocationType] =
      AwsError.unwrapOptionField("locationType", locationType)
    def getLocation: ZIO[Any, AwsError, Location] =
      AwsError.unwrapOptionField("location", location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticinference.model.AcceleratorTypeOffering
  ) extends zio.aws.elasticinference.model.AcceleratorTypeOffering.ReadOnly {
    override val acceleratorType: Option[AcceleratorTypeName] = scala
      .Option(impl.acceleratorType())
      .map(value =>
        zio.aws.elasticinference.model.primitives.AcceleratorTypeName(value)
      )
    override val locationType
        : Option[zio.aws.elasticinference.model.LocationType] = scala
      .Option(impl.locationType())
      .map(value => zio.aws.elasticinference.model.LocationType.wrap(value))
    override val location: Option[Location] = scala
      .Option(impl.location())
      .map(value => zio.aws.elasticinference.model.primitives.Location(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticinference.model.AcceleratorTypeOffering
  ): zio.aws.elasticinference.model.AcceleratorTypeOffering.ReadOnly =
    new Wrapper(impl)
}
