package zio.aws.elasticinference.model
import zio.aws.elasticinference.model.primitives.FilterName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class Filter(
    name: Option[FilterName] = None,
    values: Option[Iterable[String]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticinference.model.Filter = {
    import Filter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticinference.model.Filter
      .builder()
      .optionallyWith(
        name.map(value => FilterName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.elasticinference.model.Filter.ReadOnly =
    zio.aws.elasticinference.model.Filter.wrap(buildAwsValue())
}
object Filter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticinference.model.Filter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticinference.model.Filter =
      zio.aws.elasticinference.model
        .Filter(name.map(value => value), values.map(value => value))
    def name: Option[FilterName]
    def values: Option[List[String]]
    def getName: ZIO[Any, AwsError, FilterName] =
      AwsError.unwrapOptionField("name", name)
    def getValues: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticinference.model.Filter
  ) extends zio.aws.elasticinference.model.Filter.ReadOnly {
    override val name: Option[FilterName] = scala
      .Option(impl.name())
      .map(value => zio.aws.elasticinference.model.primitives.FilterName(value))
    override val values: Option[List[String]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticinference.model.Filter
  ): zio.aws.elasticinference.model.Filter.ReadOnly = new Wrapper(impl)
}
