package zio.aws.elasticinference.model
import zio.aws.elasticinference.model.primitives.{TagValue, TagKey, ResourceARN}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: ResourceARN,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticinference.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticinference.model.TagResourceRequest
      .builder()
      .resourceArn(ResourceARN.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticinference.model.TagResourceRequest.ReadOnly =
    zio.aws.elasticinference.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticinference.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticinference.model.TagResourceRequest =
      zio.aws.elasticinference.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: ResourceARN
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticinference.model.TagResourceRequest
  ) extends zio.aws.elasticinference.model.TagResourceRequest.ReadOnly {
    override val resourceArn: ResourceARN =
      zio.aws.elasticinference.model.primitives.ResourceARN(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.elasticinference.model.primitives.TagKey(
          key
        ) -> zio.aws.elasticinference.model.primitives.TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticinference.model.TagResourceRequest
  ): zio.aws.elasticinference.model.TagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
