package zio.aws.elasticinference.model
import java.lang.Integer
import zio.aws.elasticinference.model.primitives.{
  NextToken,
  MaxResults,
  AcceleratorId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAcceleratorsRequest(
    acceleratorIds: Option[Iterable[AcceleratorId]] = None,
    filters: Option[Iterable[zio.aws.elasticinference.model.Filter]] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsRequest = {
    import DescribeAcceleratorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsRequest
      .builder()
      .optionallyWith(
        acceleratorIds.map(value =>
          value.map { item =>
            AcceleratorId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.acceleratorIds)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticinference.model.DescribeAcceleratorsRequest.ReadOnly =
    zio.aws.elasticinference.model.DescribeAcceleratorsRequest
      .wrap(buildAwsValue())
}
object DescribeAcceleratorsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticinference.model.DescribeAcceleratorsRequest =
      zio.aws.elasticinference.model.DescribeAcceleratorsRequest(
        acceleratorIds.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def acceleratorIds: Option[List[AcceleratorId]]
    def filters: Option[List[zio.aws.elasticinference.model.Filter.ReadOnly]]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getAcceleratorIds: ZIO[Any, AwsError, List[AcceleratorId]] =
      AwsError.unwrapOptionField("acceleratorIds", acceleratorIds)
    def getFilters: ZIO[Any, AwsError, List[
      zio.aws.elasticinference.model.Filter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsRequest
  ) extends zio.aws.elasticinference.model.DescribeAcceleratorsRequest.ReadOnly {
    override val acceleratorIds: Option[List[AcceleratorId]] = scala
      .Option(impl.acceleratorIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticinference.model.primitives.AcceleratorId(item)
        }.toList
      )
    override val filters
        : Option[List[zio.aws.elasticinference.model.Filter.ReadOnly]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticinference.model.Filter.wrap(item)
        }.toList
      )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.elasticinference.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.elasticinference.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsRequest
  ): zio.aws.elasticinference.model.DescribeAcceleratorsRequest.ReadOnly =
    new Wrapper(impl)
}
