package zio.aws.elasticinference.model
import zio.aws.elasticinference.model.primitives.AcceleratorTypeName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAcceleratorOfferingsRequest(
    locationType: zio.aws.elasticinference.model.LocationType,
    acceleratorTypes: Option[Iterable[AcceleratorTypeName]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorOfferingsRequest = {
    import DescribeAcceleratorOfferingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorOfferingsRequest
      .builder()
      .locationType(locationType.unwrap)
      .optionallyWith(
        acceleratorTypes.map(value =>
          value.map { item =>
            AcceleratorTypeName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.acceleratorTypes)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticinference.model.DescribeAcceleratorOfferingsRequest.ReadOnly =
    zio.aws.elasticinference.model.DescribeAcceleratorOfferingsRequest
      .wrap(buildAwsValue())
}
object DescribeAcceleratorOfferingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorOfferingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticinference.model.DescribeAcceleratorOfferingsRequest =
      zio.aws.elasticinference.model.DescribeAcceleratorOfferingsRequest(
        locationType,
        acceleratorTypes.map(value => value)
      )
    def locationType: zio.aws.elasticinference.model.LocationType
    def acceleratorTypes: Option[List[AcceleratorTypeName]]
    def getLocationType
        : ZIO[Any, Nothing, zio.aws.elasticinference.model.LocationType] =
      ZIO.succeed(locationType)
    def getAcceleratorTypes: ZIO[Any, AwsError, List[AcceleratorTypeName]] =
      AwsError.unwrapOptionField("acceleratorTypes", acceleratorTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorOfferingsRequest
  ) extends zio.aws.elasticinference.model.DescribeAcceleratorOfferingsRequest.ReadOnly {
    override val locationType: zio.aws.elasticinference.model.LocationType =
      zio.aws.elasticinference.model.LocationType.wrap(impl.locationType())
    override val acceleratorTypes: Option[List[AcceleratorTypeName]] = scala
      .Option(impl.acceleratorTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticinference.model.primitives.AcceleratorTypeName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorOfferingsRequest
  ): zio.aws.elasticinference.model.DescribeAcceleratorOfferingsRequest.ReadOnly =
    new Wrapper(impl)
}
