package zio.aws.elasticinference
import zio.aws.elasticinference.model.DescribeAcceleratorsResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import software.amazon.awssdk.services.elasticinference.ElasticInferenceAsyncClient
import zio.aws.core.aspects.AwsCallAspect
import zio.aws.elasticinference.model.{
  ListTagsForResourceRequest,
  DescribeAcceleratorsRequest,
  DescribeAcceleratorOfferingsRequest,
  UntagResourceRequest,
  DescribeAcceleratorTypesRequest,
  TagResourceRequest
}
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object ElasticInferenceMock extends Mock[ElasticInference] {
  object DescribeAcceleratorOfferings
      extends Effect[
        DescribeAcceleratorOfferingsRequest,
        AwsError,
        zio.aws.elasticinference.model.DescribeAcceleratorOfferingsResponse.ReadOnly
      ]
  object DescribeAccelerators
      extends Stream[
        DescribeAcceleratorsRequest,
        AwsError,
        zio.aws.elasticinference.model.ElasticInferenceAccelerator.ReadOnly
      ]
  object DescribeAcceleratorsPaginated
      extends Effect[DescribeAcceleratorsRequest, AwsError, ReadOnly]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.elasticinference.model.UntagResourceResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.elasticinference.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.elasticinference.model.TagResourceResponse.ReadOnly
      ]
  object DescribeAcceleratorTypes
      extends Effect[
        DescribeAcceleratorTypesRequest,
        AwsError,
        zio.aws.elasticinference.model.DescribeAcceleratorTypesResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, ElasticInference] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new ElasticInference {
          val api: ElasticInferenceAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : ElasticInference = this
          def describeAcceleratorOfferings(
              request: DescribeAcceleratorOfferingsRequest
          ): IO[
            AwsError,
            zio.aws.elasticinference.model.DescribeAcceleratorOfferingsResponse.ReadOnly
          ] = proxy(DescribeAcceleratorOfferings, request)
          def describeAccelerators(
              request: DescribeAcceleratorsRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.elasticinference.model.ElasticInferenceAccelerator.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeAccelerators, request))
          def describeAcceleratorsPaginated(
              request: DescribeAcceleratorsRequest
          ): IO[AwsError, ReadOnly] =
            proxy(DescribeAcceleratorsPaginated, request)
          def untagResource(request: UntagResourceRequest): IO[
            AwsError,
            zio.aws.elasticinference.model.UntagResourceResponse.ReadOnly
          ] = proxy(UntagResource, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.elasticinference.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def tagResource(request: TagResourceRequest): IO[
            AwsError,
            zio.aws.elasticinference.model.TagResourceResponse.ReadOnly
          ] = proxy(TagResource, request)
          def describeAcceleratorTypes(
              request: DescribeAcceleratorTypesRequest
          ): IO[
            AwsError,
            zio.aws.elasticinference.model.DescribeAcceleratorTypesResponse.ReadOnly
          ] = proxy(DescribeAcceleratorTypes, request)
        }
      }
    }
    .toLayer
}
