package zio.aws.elasticinference.model
import java.lang.Integer
import zio.aws.elasticinference.model.primitives.{Value, Key}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class KeyValuePair(
    key: Option[Key] = None,
    value: Option[Value] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticinference.model.KeyValuePair = {
    import KeyValuePair.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticinference.model.KeyValuePair
      .builder()
      .optionallyWith(key.map(value => Key.unwrap(value): java.lang.String))(
        _.key
      )
      .optionallyWith(value.map(value => Value.unwrap(value): Integer))(_.value)
      .build()
  }
  def asReadOnly: zio.aws.elasticinference.model.KeyValuePair.ReadOnly =
    zio.aws.elasticinference.model.KeyValuePair.wrap(buildAwsValue())
}
object KeyValuePair {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticinference.model.KeyValuePair
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticinference.model.KeyValuePair =
      zio.aws.elasticinference.model
        .KeyValuePair(key.map(value => value), value.map(value => value))
    def key: Option[Key]
    def value: Option[Value]
    def getKey: ZIO[Any, AwsError, Key] = AwsError.unwrapOptionField("key", key)
    def getValue: ZIO[Any, AwsError, Value] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticinference.model.KeyValuePair
  ) extends zio.aws.elasticinference.model.KeyValuePair.ReadOnly {
    override val key: Option[Key] = scala
      .Option(impl.key())
      .map(value => zio.aws.elasticinference.model.primitives.Key(value))
    override val value: Option[Value] = scala
      .Option(impl.value())
      .map(value => zio.aws.elasticinference.model.primitives.Value(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticinference.model.KeyValuePair
  ): zio.aws.elasticinference.model.KeyValuePair.ReadOnly = new Wrapper(impl)
}
