package zio.aws.elasticinference.model
import zio.aws.elasticinference.model.primitives.{TagKey, ResourceARN}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class UntagResourceRequest(
    resourceArn: ResourceARN,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticinference.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticinference.model.UntagResourceRequest
      .builder()
      .resourceArn(ResourceARN.unwrap(resourceArn): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.elasticinference.model.UntagResourceRequest.ReadOnly =
    zio.aws.elasticinference.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticinference.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticinference.model.UntagResourceRequest =
      zio.aws.elasticinference.model.UntagResourceRequest(resourceArn, tagKeys)
    def resourceArn: ResourceARN
    def tagKeys: List[TagKey]
    def getResourceArn: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(resourceArn)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticinference.model.UntagResourceRequest
  ) extends zio.aws.elasticinference.model.UntagResourceRequest.ReadOnly {
    override val resourceArn: ResourceARN =
      zio.aws.elasticinference.model.primitives.ResourceARN(impl.resourceArn())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.elasticinference.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticinference.model.UntagResourceRequest
  ): zio.aws.elasticinference.model.UntagResourceRequest.ReadOnly = new Wrapper(
    impl
  )
}
