package zio.aws.elasticinference.model
import zio.aws.elasticinference.model.primitives.AcceleratorTypeName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AcceleratorType(
    acceleratorTypeName: Optional[AcceleratorTypeName] = Optional.Absent,
    memoryInfo: Optional[zio.aws.elasticinference.model.MemoryInfo] =
      Optional.Absent,
    throughputInfo: Optional[
      Iterable[zio.aws.elasticinference.model.KeyValuePair]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticinference.model.AcceleratorType = {
    import AcceleratorType.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticinference.model.AcceleratorType
      .builder()
      .optionallyWith(
        acceleratorTypeName.map(value =>
          AcceleratorTypeName.unwrap(value): java.lang.String
        )
      )(_.acceleratorTypeName)
      .optionallyWith(memoryInfo.map(value => value.buildAwsValue()))(
        _.memoryInfo
      )
      .optionallyWith(
        throughputInfo.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.throughputInfo)
      .build()
  }
  def asReadOnly: zio.aws.elasticinference.model.AcceleratorType.ReadOnly =
    zio.aws.elasticinference.model.AcceleratorType.wrap(buildAwsValue())
}
object AcceleratorType {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticinference.model.AcceleratorType
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticinference.model.AcceleratorType =
      zio.aws.elasticinference.model.AcceleratorType(
        acceleratorTypeName.map(value => value),
        memoryInfo.map(value => value.asEditable),
        throughputInfo.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def acceleratorTypeName: Optional[AcceleratorTypeName]
    def memoryInfo: Optional[zio.aws.elasticinference.model.MemoryInfo.ReadOnly]
    def throughputInfo
        : Optional[List[zio.aws.elasticinference.model.KeyValuePair.ReadOnly]]
    def getAcceleratorTypeName: ZIO[Any, AwsError, AcceleratorTypeName] =
      AwsError.unwrapOptionField("acceleratorTypeName", acceleratorTypeName)
    def getMemoryInfo: ZIO[
      Any,
      AwsError,
      zio.aws.elasticinference.model.MemoryInfo.ReadOnly
    ] = AwsError.unwrapOptionField("memoryInfo", memoryInfo)
    def getThroughputInfo: ZIO[Any, AwsError, List[
      zio.aws.elasticinference.model.KeyValuePair.ReadOnly
    ]] = AwsError.unwrapOptionField("throughputInfo", throughputInfo)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticinference.model.AcceleratorType
  ) extends zio.aws.elasticinference.model.AcceleratorType.ReadOnly {
    override val acceleratorTypeName: Optional[AcceleratorTypeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceleratorTypeName())
        .map(value =>
          zio.aws.elasticinference.model.primitives.AcceleratorTypeName(value)
        )
    override val memoryInfo
        : Optional[zio.aws.elasticinference.model.MemoryInfo.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.memoryInfo())
        .map(value => zio.aws.elasticinference.model.MemoryInfo.wrap(value))
    override val throughputInfo
        : Optional[List[zio.aws.elasticinference.model.KeyValuePair.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.throughputInfo())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticinference.model.KeyValuePair.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticinference.model.AcceleratorType
  ): zio.aws.elasticinference.model.AcceleratorType.ReadOnly = new Wrapper(impl)
}
