package zio.aws.elasticinference.model
import zio.aws.elasticinference.model.primitives.ResourceARN
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class ListTagsForResourceRequest(resourceArn: ResourceARN) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticinference.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticinference.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(ResourceARN.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticinference.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.elasticinference.model.ListTagsForResourceRequest
      .wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticinference.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticinference.model.ListTagsForResourceRequest =
      zio.aws.elasticinference.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: ResourceARN
    def getResourceArn: ZIO[Any, Nothing, ResourceARN] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticinference.model.ListTagsForResourceRequest
  ) extends zio.aws.elasticinference.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: ResourceARN =
      zio.aws.elasticinference.model.primitives.ResourceARN(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticinference.model.ListTagsForResourceRequest
  ): zio.aws.elasticinference.model.ListTagsForResourceRequest.ReadOnly =
    new Wrapper(impl)
}
