package zio.aws.elasticinference.model
import zio.aws.elasticinference.model.primitives.{
  ResourceArn,
  AvailabilityZone,
  AcceleratorId,
  AcceleratorTypeName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ElasticInferenceAccelerator(
    acceleratorHealth: Optional[
      zio.aws.elasticinference.model.ElasticInferenceAcceleratorHealth
    ] = Optional.Absent,
    acceleratorType: Optional[AcceleratorTypeName] = Optional.Absent,
    acceleratorId: Optional[AcceleratorId] = Optional.Absent,
    availabilityZone: Optional[AvailabilityZone] = Optional.Absent,
    attachedResource: Optional[ResourceArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticinference.model.ElasticInferenceAccelerator = {
    import ElasticInferenceAccelerator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticinference.model.ElasticInferenceAccelerator
      .builder()
      .optionallyWith(acceleratorHealth.map(value => value.buildAwsValue()))(
        _.acceleratorHealth
      )
      .optionallyWith(
        acceleratorType.map(value =>
          AcceleratorTypeName.unwrap(value): java.lang.String
        )
      )(_.acceleratorType)
      .optionallyWith(
        acceleratorId.map(value =>
          AcceleratorId.unwrap(value): java.lang.String
        )
      )(_.acceleratorId)
      .optionallyWith(
        availabilityZone.map(value =>
          AvailabilityZone.unwrap(value): java.lang.String
        )
      )(_.availabilityZone)
      .optionallyWith(
        attachedResource.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.attachedResource)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticinference.model.ElasticInferenceAccelerator.ReadOnly =
    zio.aws.elasticinference.model.ElasticInferenceAccelerator
      .wrap(buildAwsValue())
}
object ElasticInferenceAccelerator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticinference.model.ElasticInferenceAccelerator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticinference.model.ElasticInferenceAccelerator =
      zio.aws.elasticinference.model.ElasticInferenceAccelerator(
        acceleratorHealth.map(value => value.asEditable),
        acceleratorType.map(value => value),
        acceleratorId.map(value => value),
        availabilityZone.map(value => value),
        attachedResource.map(value => value)
      )
    def acceleratorHealth: Optional[
      zio.aws.elasticinference.model.ElasticInferenceAcceleratorHealth.ReadOnly
    ]
    def acceleratorType: Optional[AcceleratorTypeName]
    def acceleratorId: Optional[AcceleratorId]
    def availabilityZone: Optional[AvailabilityZone]
    def attachedResource: Optional[ResourceArn]
    def getAcceleratorHealth: ZIO[
      Any,
      AwsError,
      zio.aws.elasticinference.model.ElasticInferenceAcceleratorHealth.ReadOnly
    ] = AwsError.unwrapOptionField("acceleratorHealth", acceleratorHealth)
    def getAcceleratorType: ZIO[Any, AwsError, AcceleratorTypeName] =
      AwsError.unwrapOptionField("acceleratorType", acceleratorType)
    def getAcceleratorId: ZIO[Any, AwsError, AcceleratorId] =
      AwsError.unwrapOptionField("acceleratorId", acceleratorId)
    def getAvailabilityZone: ZIO[Any, AwsError, AvailabilityZone] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getAttachedResource: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("attachedResource", attachedResource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticinference.model.ElasticInferenceAccelerator
  ) extends zio.aws.elasticinference.model.ElasticInferenceAccelerator.ReadOnly {
    override val acceleratorHealth: Optional[
      zio.aws.elasticinference.model.ElasticInferenceAcceleratorHealth.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.acceleratorHealth())
      .map(value =>
        zio.aws.elasticinference.model.ElasticInferenceAcceleratorHealth
          .wrap(value)
      )
    override val acceleratorType: Optional[AcceleratorTypeName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.acceleratorType())
        .map(value =>
          zio.aws.elasticinference.model.primitives.AcceleratorTypeName(value)
        )
    override val acceleratorId: Optional[AcceleratorId] = zio.aws.core.internal
      .optionalFromNullable(impl.acceleratorId())
      .map(value =>
        zio.aws.elasticinference.model.primitives.AcceleratorId(value)
      )
    override val availabilityZone: Optional[AvailabilityZone] =
      zio.aws.core.internal
        .optionalFromNullable(impl.availabilityZone())
        .map(value =>
          zio.aws.elasticinference.model.primitives.AvailabilityZone(value)
        )
    override val attachedResource: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.attachedResource())
      .map(value =>
        zio.aws.elasticinference.model.primitives.ResourceArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticinference.model.ElasticInferenceAccelerator
  ): zio.aws.elasticinference.model.ElasticInferenceAccelerator.ReadOnly =
    new Wrapper(impl)
}
