package zio.aws.elasticinference.model
import zio.aws.elasticinference.model.primitives.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class MemoryInfo(sizeInMiB: Optional[Integer] = Optional.Absent) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticinference.model.MemoryInfo = {
    import MemoryInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticinference.model.MemoryInfo
      .builder()
      .optionallyWith(sizeInMiB.map(value => value: java.lang.Integer))(
        _.sizeInMiB
      )
      .build()
  }
  def asReadOnly: zio.aws.elasticinference.model.MemoryInfo.ReadOnly =
    zio.aws.elasticinference.model.MemoryInfo.wrap(buildAwsValue())
}
object MemoryInfo {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticinference.model.MemoryInfo
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticinference.model.MemoryInfo =
      zio.aws.elasticinference.model.MemoryInfo(sizeInMiB.map(value => value))
    def sizeInMiB: Optional[Integer]
    def getSizeInMiB: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("sizeInMiB", sizeInMiB)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticinference.model.MemoryInfo
  ) extends zio.aws.elasticinference.model.MemoryInfo.ReadOnly {
    override val sizeInMiB: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.sizeInMiB())
      .map(value => value: Integer)
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticinference.model.MemoryInfo
  ): zio.aws.elasticinference.model.MemoryInfo.ReadOnly = new Wrapper(impl)
}
