package zio.aws.elasticinference.model
import zio.aws.elasticinference.model.primitives.{
  ResourceArn,
  AvailabilityZone,
  AcceleratorId,
  AcceleratorTypeName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class ElasticInferenceAccelerator(
    acceleratorHealth: Option[
      zio.aws.elasticinference.model.ElasticInferenceAcceleratorHealth
    ] = None,
    acceleratorType: Option[AcceleratorTypeName] = None,
    acceleratorId: Option[AcceleratorId] = None,
    availabilityZone: Option[AvailabilityZone] = None,
    attachedResource: Option[ResourceArn] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticinference.model.ElasticInferenceAccelerator = {
    import ElasticInferenceAccelerator.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticinference.model.ElasticInferenceAccelerator
      .builder()
      .optionallyWith(acceleratorHealth.map(value => value.buildAwsValue()))(
        _.acceleratorHealth
      )
      .optionallyWith(
        acceleratorType.map(value =>
          AcceleratorTypeName.unwrap(value): java.lang.String
        )
      )(_.acceleratorType)
      .optionallyWith(
        acceleratorId.map(value =>
          AcceleratorId.unwrap(value): java.lang.String
        )
      )(_.acceleratorId)
      .optionallyWith(
        availabilityZone.map(value =>
          AvailabilityZone.unwrap(value): java.lang.String
        )
      )(_.availabilityZone)
      .optionallyWith(
        attachedResource.map(value =>
          ResourceArn.unwrap(value): java.lang.String
        )
      )(_.attachedResource)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticinference.model.ElasticInferenceAccelerator.ReadOnly =
    zio.aws.elasticinference.model.ElasticInferenceAccelerator
      .wrap(buildAwsValue())
}
object ElasticInferenceAccelerator {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticinference.model.ElasticInferenceAccelerator
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticinference.model.ElasticInferenceAccelerator =
      zio.aws.elasticinference.model.ElasticInferenceAccelerator(
        acceleratorHealth.map(value => value.asEditable),
        acceleratorType.map(value => value),
        acceleratorId.map(value => value),
        availabilityZone.map(value => value),
        attachedResource.map(value => value)
      )
    def acceleratorHealth: Option[
      zio.aws.elasticinference.model.ElasticInferenceAcceleratorHealth.ReadOnly
    ]
    def acceleratorType: Option[AcceleratorTypeName]
    def acceleratorId: Option[AcceleratorId]
    def availabilityZone: Option[AvailabilityZone]
    def attachedResource: Option[ResourceArn]
    def getAcceleratorHealth: ZIO[
      Any,
      AwsError,
      zio.aws.elasticinference.model.ElasticInferenceAcceleratorHealth.ReadOnly
    ] = AwsError.unwrapOptionField("acceleratorHealth", acceleratorHealth)
    def getAcceleratorType: ZIO[Any, AwsError, AcceleratorTypeName] =
      AwsError.unwrapOptionField("acceleratorType", acceleratorType)
    def getAcceleratorId: ZIO[Any, AwsError, AcceleratorId] =
      AwsError.unwrapOptionField("acceleratorId", acceleratorId)
    def getAvailabilityZone: ZIO[Any, AwsError, AvailabilityZone] =
      AwsError.unwrapOptionField("availabilityZone", availabilityZone)
    def getAttachedResource: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("attachedResource", attachedResource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticinference.model.ElasticInferenceAccelerator
  ) extends zio.aws.elasticinference.model.ElasticInferenceAccelerator.ReadOnly {
    override val acceleratorHealth: Option[
      zio.aws.elasticinference.model.ElasticInferenceAcceleratorHealth.ReadOnly
    ] = scala
      .Option(impl.acceleratorHealth())
      .map(value =>
        zio.aws.elasticinference.model.ElasticInferenceAcceleratorHealth
          .wrap(value)
      )
    override val acceleratorType: Option[AcceleratorTypeName] = scala
      .Option(impl.acceleratorType())
      .map(value =>
        zio.aws.elasticinference.model.primitives.AcceleratorTypeName(value)
      )
    override val acceleratorId: Option[AcceleratorId] = scala
      .Option(impl.acceleratorId())
      .map(value =>
        zio.aws.elasticinference.model.primitives.AcceleratorId(value)
      )
    override val availabilityZone: Option[AvailabilityZone] = scala
      .Option(impl.availabilityZone())
      .map(value =>
        zio.aws.elasticinference.model.primitives.AvailabilityZone(value)
      )
    override val attachedResource: Option[ResourceArn] = scala
      .Option(impl.attachedResource())
      .map(value =>
        zio.aws.elasticinference.model.primitives.ResourceArn(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticinference.model.ElasticInferenceAccelerator
  ): zio.aws.elasticinference.model.ElasticInferenceAccelerator.ReadOnly =
    new Wrapper(impl)
}
