package zio.aws.elasticinference.model
import zio.aws.elasticinference.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAcceleratorsResponse(
    acceleratorSet: Option[
      Iterable[zio.aws.elasticinference.model.ElasticInferenceAccelerator]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsResponse = {
    import DescribeAcceleratorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsResponse
      .builder()
      .optionallyWith(
        acceleratorSet.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.acceleratorSet)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticinference.model.DescribeAcceleratorsResponse.ReadOnly =
    zio.aws.elasticinference.model.DescribeAcceleratorsResponse
      .wrap(buildAwsValue())
}
object DescribeAcceleratorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticinference.model.DescribeAcceleratorsResponse =
      zio.aws.elasticinference.model.DescribeAcceleratorsResponse(
        acceleratorSet.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def acceleratorSet: Option[
      List[zio.aws.elasticinference.model.ElasticInferenceAccelerator.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getAcceleratorSet: ZIO[Any, AwsError, List[
      zio.aws.elasticinference.model.ElasticInferenceAccelerator.ReadOnly
    ]] = AwsError.unwrapOptionField("acceleratorSet", acceleratorSet)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsResponse
  ) extends zio.aws.elasticinference.model.DescribeAcceleratorsResponse.ReadOnly {
    override val acceleratorSet: Option[
      List[zio.aws.elasticinference.model.ElasticInferenceAccelerator.ReadOnly]
    ] = scala
      .Option(impl.acceleratorSet())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticinference.model.ElasticInferenceAccelerator.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.elasticinference.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsResponse
  ): zio.aws.elasticinference.model.DescribeAcceleratorsResponse.ReadOnly =
    new Wrapper(impl)
}
