package zio.aws.elasticinference.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters._
final case class DescribeAcceleratorTypesResponse(
    acceleratorTypes: Option[
      Iterable[zio.aws.elasticinference.model.AcceleratorType]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorTypesResponse = {
    import DescribeAcceleratorTypesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorTypesResponse
      .builder()
      .optionallyWith(
        acceleratorTypes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.acceleratorTypes)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticinference.model.DescribeAcceleratorTypesResponse.ReadOnly =
    zio.aws.elasticinference.model.DescribeAcceleratorTypesResponse
      .wrap(buildAwsValue())
}
object DescribeAcceleratorTypesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorTypesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticinference.model.DescribeAcceleratorTypesResponse =
      zio.aws.elasticinference.model.DescribeAcceleratorTypesResponse(
        acceleratorTypes.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def acceleratorTypes
        : Option[List[zio.aws.elasticinference.model.AcceleratorType.ReadOnly]]
    def getAcceleratorTypes: ZIO[Any, AwsError, List[
      zio.aws.elasticinference.model.AcceleratorType.ReadOnly
    ]] = AwsError.unwrapOptionField("acceleratorTypes", acceleratorTypes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorTypesResponse
  ) extends zio.aws.elasticinference.model.DescribeAcceleratorTypesResponse.ReadOnly {
    override val acceleratorTypes: Option[
      List[zio.aws.elasticinference.model.AcceleratorType.ReadOnly]
    ] = scala
      .Option(impl.acceleratorTypes())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.elasticinference.model.AcceleratorType.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorTypesResponse
  ): zio.aws.elasticinference.model.DescribeAcceleratorTypesResponse.ReadOnly =
    new Wrapper(impl)
}
