package zio.aws.elasticinference
import zio.aws.elasticinference.model.DescribeAcceleratorsResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.elasticinference.{
  ElasticInferenceAsyncClientBuilder,
  ElasticInferenceAsyncClient
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.aws.elasticinference.model.{
  ListTagsForResourceRequest,
  DescribeAcceleratorsRequest,
  DescribeAcceleratorOfferingsRequest,
  UntagResourceRequest,
  DescribeAcceleratorTypesRequest,
  TagResourceRequest
}
import zio.{ZEnvironment, ZManaged, IO, ZIO, ZLayer}
import software.amazon.awssdk.services.elasticinference.model.{
  DescribeAcceleratorsResponse,
  DescribeAcceleratorOfferingsResponse,
  ElasticInferenceAccelerator,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  DescribeAcceleratorTypesResponse,
  TagResourceResponse
}
import zio.stream.ZStream
import software.amazon.awssdk.services.elasticinference.paginators.DescribeAcceleratorsPublisher
import scala.jdk.CollectionConverters._
trait ElasticInference extends AspectSupport[ElasticInference] {
  val api: ElasticInferenceAsyncClient
  def describeAcceleratorOfferings(
      request: DescribeAcceleratorOfferingsRequest
  ): IO[
    AwsError,
    zio.aws.elasticinference.model.DescribeAcceleratorOfferingsResponse.ReadOnly
  ]
  def describeAccelerators(request: DescribeAcceleratorsRequest): ZStream[
    Any,
    AwsError,
    zio.aws.elasticinference.model.ElasticInferenceAccelerator.ReadOnly
  ]
  def describeAcceleratorsPaginated(
      request: DescribeAcceleratorsRequest
  ): IO[AwsError, ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.elasticinference.model.UntagResourceResponse.ReadOnly]
  def listTagsForResource(request: ListTagsForResourceRequest): IO[
    AwsError,
    zio.aws.elasticinference.model.ListTagsForResourceResponse.ReadOnly
  ]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.elasticinference.model.TagResourceResponse.ReadOnly]
  def describeAcceleratorTypes(request: DescribeAcceleratorTypesRequest): IO[
    AwsError,
    zio.aws.elasticinference.model.DescribeAcceleratorTypesResponse.ReadOnly
  ]
}
object ElasticInference {
  val live: ZLayer[AwsConfig, java.lang.Throwable, ElasticInference] =
    customized(identity)
  def customized(
      customization: ElasticInferenceAsyncClientBuilder => ElasticInferenceAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, ElasticInference] = managed(
    customization
  ).toLayer
  def managed(
      customization: ElasticInferenceAsyncClientBuilder => ElasticInferenceAsyncClientBuilder
  ): ZManaged[AwsConfig, java.lang.Throwable, ElasticInference] = for (
    awsConfig <- ZManaged.service[AwsConfig];
    executor <- ZIO.executor.toManaged;
    builder = ElasticInferenceAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig
      .configure[
        ElasticInferenceAsyncClient,
        ElasticInferenceAsyncClientBuilder
      ](builder)
      .toManaged;
    b1 <- awsConfig
      .configureHttpClient[
        ElasticInferenceAsyncClient,
        ElasticInferenceAsyncClientBuilder
      ](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      )
      .toManaged; client <- zio.ZIO(customization(b1).build()).toManaged
  )
    yield new ElasticInferenceImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class ElasticInferenceImpl[R](
      override val api: ElasticInferenceAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends ElasticInference
      with AwsServiceBase[R] {
    override val serviceName: String = "ElasticInference"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): ElasticInferenceImpl[R1] = new ElasticInferenceImpl(api, newAspect, r)
    def describeAcceleratorOfferings(
        request: DescribeAcceleratorOfferingsRequest
    ): IO[
      AwsError,
      zio.aws.elasticinference.model.DescribeAcceleratorOfferingsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorOfferingsRequest,
      DescribeAcceleratorOfferingsResponse
    ]("describeAcceleratorOfferings", api.describeAcceleratorOfferings)(
      request.buildAwsValue()
    ).map(
      zio.aws.elasticinference.model.DescribeAcceleratorOfferingsResponse.wrap
    ).provideEnvironment(r)
    def describeAccelerators(request: DescribeAcceleratorsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.elasticinference.model.ElasticInferenceAccelerator.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsRequest,
      ElasticInferenceAccelerator,
      DescribeAcceleratorsPublisher
    ](
      "describeAccelerators",
      api.describeAcceleratorsPaginator,
      _.acceleratorSet()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.elasticinference.model.ElasticInferenceAccelerator.wrap(item)
      )
      .provideEnvironment(r)
    def describeAcceleratorsPaginated(
        request: DescribeAcceleratorsRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorsRequest,
      DescribeAcceleratorsResponse
    ]("describeAccelerators", api.describeAccelerators)(request.buildAwsValue())
      .map(zio.aws.elasticinference.model.DescribeAcceleratorsResponse.wrap)
      .provideEnvironment(r)
    def untagResource(request: UntagResourceRequest): IO[
      AwsError,
      zio.aws.elasticinference.model.UntagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticinference.model.UntagResourceRequest,
      UntagResourceResponse
    ]("untagResource", api.untagResource)(request.buildAwsValue())
      .map(zio.aws.elasticinference.model.UntagResourceResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(request: ListTagsForResourceRequest): IO[
      AwsError,
      zio.aws.elasticinference.model.ListTagsForResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticinference.model.ListTagsForResourceRequest,
      ListTagsForResourceResponse
    ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
      .map(zio.aws.elasticinference.model.ListTagsForResourceResponse.wrap)
      .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[
      AwsError,
      zio.aws.elasticinference.model.TagResourceResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticinference.model.TagResourceRequest,
      TagResourceResponse
    ]("tagResource", api.tagResource)(request.buildAwsValue())
      .map(zio.aws.elasticinference.model.TagResourceResponse.wrap)
      .provideEnvironment(r)
    def describeAcceleratorTypes(request: DescribeAcceleratorTypesRequest): IO[
      AwsError,
      zio.aws.elasticinference.model.DescribeAcceleratorTypesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.elasticinference.model.DescribeAcceleratorTypesRequest,
      DescribeAcceleratorTypesResponse
    ]("describeAcceleratorTypes", api.describeAcceleratorTypes)(
      request.buildAwsValue()
    ).map(zio.aws.elasticinference.model.DescribeAcceleratorTypesResponse.wrap)
      .provideEnvironment(r)
  }
  def describeAcceleratorOfferings(
      request: DescribeAcceleratorOfferingsRequest
  ): ZIO[
    zio.aws.elasticinference.ElasticInference,
    AwsError,
    zio.aws.elasticinference.model.DescribeAcceleratorOfferingsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAcceleratorOfferings(request))
  def describeAccelerators(request: DescribeAcceleratorsRequest): ZStream[
    zio.aws.elasticinference.ElasticInference,
    AwsError,
    zio.aws.elasticinference.model.ElasticInferenceAccelerator.ReadOnly
  ] = ZStream.serviceWithStream(_.describeAccelerators(request))
  def describeAcceleratorsPaginated(
      request: DescribeAcceleratorsRequest
  ): ZIO[zio.aws.elasticinference.ElasticInference, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.describeAcceleratorsPaginated(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.elasticinference.ElasticInference,
    AwsError,
    zio.aws.elasticinference.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.elasticinference.ElasticInference,
    AwsError,
    zio.aws.elasticinference.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.elasticinference.ElasticInference,
    AwsError,
    zio.aws.elasticinference.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def describeAcceleratorTypes(request: DescribeAcceleratorTypesRequest): ZIO[
    zio.aws.elasticinference.ElasticInference,
    AwsError,
    zio.aws.elasticinference.model.DescribeAcceleratorTypesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeAcceleratorTypes(request))
}
