package zio.aws.elasticinference
import zio.prelude.Subtype
import zio.aws.elasticinference.model.primitives.{
  TagValue,
  TagKey,
  AcceleratorTypeName,
  AcceleratorId
}
import zio.aws.elasticinference.model.primitives.AcceleratorTypeName.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AcceleratorHealthStatus extends Subtype[String]
    type AcceleratorHealthStatus =
      zio.aws.elasticinference.model.primitives.AcceleratorHealthStatus.Type
    object AcceleratorId extends Subtype[String]
    type AcceleratorId =
      zio.aws.elasticinference.model.primitives.AcceleratorId.Type
    object AcceleratorTypeName extends Subtype[String]
    type AcceleratorTypeName =
      zio.aws.elasticinference.model.primitives.AcceleratorTypeName.Type
    object AvailabilityZone extends Subtype[String]
    type AvailabilityZone =
      zio.aws.elasticinference.model.primitives.AvailabilityZone.Type
    object FilterName extends Subtype[String]
    type FilterName = zio.aws.elasticinference.model.primitives.FilterName.Type
    object Integer extends Subtype[Int]
    type Integer = zio.aws.elasticinference.model.primitives.Integer.Type
    object Key extends Subtype[String]
    type Key = zio.aws.elasticinference.model.primitives.Key.Type
    object Location extends Subtype[String]
    type Location = zio.aws.elasticinference.model.primitives.Location.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.elasticinference.model.primitives.MaxResults.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.elasticinference.model.primitives.NextToken.Type
    object ResourceARN extends Subtype[String]
    type ResourceARN =
      zio.aws.elasticinference.model.primitives.ResourceARN.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn =
      zio.aws.elasticinference.model.primitives.ResourceArn.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.elasticinference.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.elasticinference.model.primitives.TagValue.Type
    object Value extends Subtype[Int]
    type Value = zio.aws.elasticinference.model.primitives.Value.Type
  }
  type AcceleratorIdList = List[AcceleratorId]
  type AcceleratorTypeList =
    List[zio.aws.elasticinference.model.AcceleratorType]
  type AcceleratorTypeNameList = List[AcceleratorTypeName]
  type AcceleratorTypeOfferingList =
    List[zio.aws.elasticinference.model.AcceleratorTypeOffering]
  type ElasticInferenceAcceleratorSet =
    List[zio.aws.elasticinference.model.ElasticInferenceAccelerator]
  type FilterList = List[zio.aws.elasticinference.model.Filter]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type ThroughputInfoList = List[zio.aws.elasticinference.model.KeyValuePair]
  type ValueStringList = List[String]
}
