package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.elasticbeanstalk.model.primitives.ApplicationName
import scala.jdk.CollectionConverters.*
final case class UpdateApplicationResourceLifecycleRequest(
    applicationName: ApplicationName,
    resourceLifecycleConfig: zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResourceLifecycleRequest = {
    import UpdateApplicationResourceLifecycleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResourceLifecycleRequest
      .builder()
      .applicationName(
        ApplicationName.unwrap(applicationName): java.lang.String
      )
      .resourceLifecycleConfig(resourceLifecycleConfig.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.UpdateApplicationResourceLifecycleRequest.ReadOnly =
    zio.aws.elasticbeanstalk.model.UpdateApplicationResourceLifecycleRequest
      .wrap(buildAwsValue())
}
object UpdateApplicationResourceLifecycleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResourceLifecycleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.elasticbeanstalk.model.UpdateApplicationResourceLifecycleRequest =
      zio.aws.elasticbeanstalk.model.UpdateApplicationResourceLifecycleRequest(
        applicationName,
        resourceLifecycleConfig.asEditable
      )
    def applicationName: ApplicationName
    def resourceLifecycleConfig
        : zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig.ReadOnly
    def getApplicationName: ZIO[Any, Nothing, ApplicationName] =
      ZIO.succeed(applicationName)
    def getResourceLifecycleConfig: ZIO[
      Any,
      Nothing,
      zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig.ReadOnly
    ] = ZIO.succeed(resourceLifecycleConfig)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResourceLifecycleRequest
  ) extends zio.aws.elasticbeanstalk.model.UpdateApplicationResourceLifecycleRequest.ReadOnly {
    override val applicationName: ApplicationName =
      zio.aws.elasticbeanstalk.model.primitives
        .ApplicationName(impl.applicationName())
    override val resourceLifecycleConfig
        : zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig.ReadOnly =
      zio.aws.elasticbeanstalk.model.ApplicationResourceLifecycleConfig
        .wrap(impl.resourceLifecycleConfig())
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.UpdateApplicationResourceLifecycleRequest
  ): zio.aws.elasticbeanstalk.model.UpdateApplicationResourceLifecycleRequest.ReadOnly =
    new Wrapper(impl)
}
