package zio.aws.elasticbeanstalk.model
import zio.aws.elasticbeanstalk.model.primitives.{
  Message,
  SampleTimestamp,
  Ec2InstanceId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class EnvironmentInfoDescription(
    infoType: Optional[zio.aws.elasticbeanstalk.model.EnvironmentInfoType] =
      Optional.Absent,
    ec2InstanceId: Optional[Ec2InstanceId] = Optional.Absent,
    sampleTimestamp: Optional[SampleTimestamp] = Optional.Absent,
    message: Optional[Message] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoDescription = {
    import EnvironmentInfoDescription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoDescription
      .builder()
      .optionallyWith(infoType.map(value => value.unwrap))(_.infoType)
      .optionallyWith(
        ec2InstanceId.map(value =>
          Ec2InstanceId.unwrap(value): java.lang.String
        )
      )(_.ec2InstanceId)
      .optionallyWith(
        sampleTimestamp.map(value => SampleTimestamp.unwrap(value): Instant)
      )(_.sampleTimestamp)
      .optionallyWith(
        message.map(value => Message.unwrap(value): java.lang.String)
      )(_.message)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.EnvironmentInfoDescription.ReadOnly =
    zio.aws.elasticbeanstalk.model.EnvironmentInfoDescription
      .wrap(buildAwsValue())
}
object EnvironmentInfoDescription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoDescription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.EnvironmentInfoDescription =
      zio.aws.elasticbeanstalk.model.EnvironmentInfoDescription(
        infoType.map(value => value),
        ec2InstanceId.map(value => value),
        sampleTimestamp.map(value => value),
        message.map(value => value)
      )
    def infoType: Optional[zio.aws.elasticbeanstalk.model.EnvironmentInfoType]
    def ec2InstanceId: Optional[Ec2InstanceId]
    def sampleTimestamp: Optional[SampleTimestamp]
    def message: Optional[Message]
    def getInfoType: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.EnvironmentInfoType
    ] = AwsError.unwrapOptionField("infoType", infoType)
    def getEc2InstanceId: ZIO[Any, AwsError, Ec2InstanceId] =
      AwsError.unwrapOptionField("ec2InstanceId", ec2InstanceId)
    def getSampleTimestamp: ZIO[Any, AwsError, SampleTimestamp] =
      AwsError.unwrapOptionField("sampleTimestamp", sampleTimestamp)
    def getMessage: ZIO[Any, AwsError, Message] =
      AwsError.unwrapOptionField("message", message)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoDescription
  ) extends zio.aws.elasticbeanstalk.model.EnvironmentInfoDescription.ReadOnly {
    override val infoType
        : Optional[zio.aws.elasticbeanstalk.model.EnvironmentInfoType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.infoType())
        .map(value =>
          zio.aws.elasticbeanstalk.model.EnvironmentInfoType.wrap(value)
        )
    override val ec2InstanceId: Optional[Ec2InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.ec2InstanceId())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.Ec2InstanceId(value)
      )
    override val sampleTimestamp: Optional[SampleTimestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sampleTimestamp())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.SampleTimestamp(value)
        )
    override val message: Optional[Message] = zio.aws.core.internal
      .optionalFromNullable(impl.message())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.Message(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.EnvironmentInfoDescription
  ): zio.aws.elasticbeanstalk.model.EnvironmentInfoDescription.ReadOnly =
    new Wrapper(impl)
}
