package zio.aws.elasticbeanstalk.model
import zio.aws.elasticbeanstalk.model.primitives.Timestamp
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ManagedActionHistoryItem(
    actionId: Optional[String] = Optional.Absent,
    actionType: Optional[zio.aws.elasticbeanstalk.model.ActionType] =
      Optional.Absent,
    actionDescription: Optional[String] = Optional.Absent,
    failureType: Optional[zio.aws.elasticbeanstalk.model.FailureType] =
      Optional.Absent,
    status: Optional[zio.aws.elasticbeanstalk.model.ActionHistoryStatus] =
      Optional.Absent,
    failureDescription: Optional[String] = Optional.Absent,
    executedTime: Optional[Timestamp] = Optional.Absent,
    finishedTime: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.ManagedActionHistoryItem = {
    import ManagedActionHistoryItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.ManagedActionHistoryItem
      .builder()
      .optionallyWith(actionId.map(value => value: java.lang.String))(
        _.actionId
      )
      .optionallyWith(actionType.map(value => value.unwrap))(_.actionType)
      .optionallyWith(actionDescription.map(value => value: java.lang.String))(
        _.actionDescription
      )
      .optionallyWith(failureType.map(value => value.unwrap))(_.failureType)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(failureDescription.map(value => value: java.lang.String))(
        _.failureDescription
      )
      .optionallyWith(
        executedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.executedTime)
      .optionallyWith(
        finishedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.finishedTime)
      .build()
  }
  def asReadOnly
      : zio.aws.elasticbeanstalk.model.ManagedActionHistoryItem.ReadOnly =
    zio.aws.elasticbeanstalk.model.ManagedActionHistoryItem
      .wrap(buildAwsValue())
}
object ManagedActionHistoryItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.ManagedActionHistoryItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.ManagedActionHistoryItem =
      zio.aws.elasticbeanstalk.model.ManagedActionHistoryItem(
        actionId.map(value => value),
        actionType.map(value => value),
        actionDescription.map(value => value),
        failureType.map(value => value),
        status.map(value => value),
        failureDescription.map(value => value),
        executedTime.map(value => value),
        finishedTime.map(value => value)
      )
    def actionId: Optional[String]
    def actionType: Optional[zio.aws.elasticbeanstalk.model.ActionType]
    def actionDescription: Optional[String]
    def failureType: Optional[zio.aws.elasticbeanstalk.model.FailureType]
    def status: Optional[zio.aws.elasticbeanstalk.model.ActionHistoryStatus]
    def failureDescription: Optional[String]
    def executedTime: Optional[Timestamp]
    def finishedTime: Optional[Timestamp]
    def getActionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("actionId", actionId)
    def getActionType
        : ZIO[Any, AwsError, zio.aws.elasticbeanstalk.model.ActionType] =
      AwsError.unwrapOptionField("actionType", actionType)
    def getActionDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("actionDescription", actionDescription)
    def getFailureType
        : ZIO[Any, AwsError, zio.aws.elasticbeanstalk.model.FailureType] =
      AwsError.unwrapOptionField("failureType", failureType)
    def getStatus: ZIO[
      Any,
      AwsError,
      zio.aws.elasticbeanstalk.model.ActionHistoryStatus
    ] = AwsError.unwrapOptionField("status", status)
    def getFailureDescription: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("failureDescription", failureDescription)
    def getExecutedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("executedTime", executedTime)
    def getFinishedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("finishedTime", finishedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ManagedActionHistoryItem
  ) extends zio.aws.elasticbeanstalk.model.ManagedActionHistoryItem.ReadOnly {
    override val actionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.actionId())
      .map(value => value: String)
    override val actionType
        : Optional[zio.aws.elasticbeanstalk.model.ActionType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionType())
        .map(value => zio.aws.elasticbeanstalk.model.ActionType.wrap(value))
    override val actionDescription: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.actionDescription())
      .map(value => value: String)
    override val failureType
        : Optional[zio.aws.elasticbeanstalk.model.FailureType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failureType())
        .map(value => zio.aws.elasticbeanstalk.model.FailureType.wrap(value))
    override val status
        : Optional[zio.aws.elasticbeanstalk.model.ActionHistoryStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.elasticbeanstalk.model.ActionHistoryStatus.wrap(value)
        )
    override val failureDescription: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.failureDescription())
      .map(value => value: String)
    override val executedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.executedTime())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.Timestamp(value))
    override val finishedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.finishedTime())
      .map(value => zio.aws.elasticbeanstalk.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.ManagedActionHistoryItem
  ): zio.aws.elasticbeanstalk.model.ManagedActionHistoryItem.ReadOnly =
    new Wrapper(impl)
}
