package zio.aws.elasticbeanstalk.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.elasticbeanstalk.model.primitives.{
  PlatformCategory,
  OperatingSystemVersion,
  SupportedTier,
  PlatformArn,
  PlatformLifecycleState,
  SupportedAddon,
  PlatformBranchLifecycleState,
  PlatformVersion,
  PlatformOwner,
  OperatingSystemName,
  BranchName
}
import scala.jdk.CollectionConverters.*
final case class PlatformSummary(
    platformArn: Optional[PlatformArn] = Optional.Absent,
    platformOwner: Optional[PlatformOwner] = Optional.Absent,
    platformStatus: Optional[zio.aws.elasticbeanstalk.model.PlatformStatus] =
      Optional.Absent,
    platformCategory: Optional[PlatformCategory] = Optional.Absent,
    operatingSystemName: Optional[OperatingSystemName] = Optional.Absent,
    operatingSystemVersion: Optional[OperatingSystemVersion] = Optional.Absent,
    supportedTierList: Optional[Iterable[SupportedTier]] = Optional.Absent,
    supportedAddonList: Optional[Iterable[SupportedAddon]] = Optional.Absent,
    platformLifecycleState: Optional[PlatformLifecycleState] = Optional.Absent,
    platformVersion: Optional[PlatformVersion] = Optional.Absent,
    platformBranchName: Optional[BranchName] = Optional.Absent,
    platformBranchLifecycleState: Optional[PlatformBranchLifecycleState] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.elasticbeanstalk.model.PlatformSummary = {
    import PlatformSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.elasticbeanstalk.model.PlatformSummary
      .builder()
      .optionallyWith(
        platformArn.map(value => PlatformArn.unwrap(value): java.lang.String)
      )(_.platformArn)
      .optionallyWith(
        platformOwner.map(value =>
          PlatformOwner.unwrap(value): java.lang.String
        )
      )(_.platformOwner)
      .optionallyWith(platformStatus.map(value => value.unwrap))(
        _.platformStatus
      )
      .optionallyWith(
        platformCategory.map(value =>
          PlatformCategory.unwrap(value): java.lang.String
        )
      )(_.platformCategory)
      .optionallyWith(
        operatingSystemName.map(value =>
          OperatingSystemName.unwrap(value): java.lang.String
        )
      )(_.operatingSystemName)
      .optionallyWith(
        operatingSystemVersion.map(value =>
          OperatingSystemVersion.unwrap(value): java.lang.String
        )
      )(_.operatingSystemVersion)
      .optionallyWith(
        supportedTierList.map(value =>
          value.map { item =>
            SupportedTier.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.supportedTierList)
      .optionallyWith(
        supportedAddonList.map(value =>
          value.map { item =>
            SupportedAddon.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.supportedAddonList)
      .optionallyWith(
        platformLifecycleState.map(value =>
          PlatformLifecycleState.unwrap(value): java.lang.String
        )
      )(_.platformLifecycleState)
      .optionallyWith(
        platformVersion.map(value =>
          PlatformVersion.unwrap(value): java.lang.String
        )
      )(_.platformVersion)
      .optionallyWith(
        platformBranchName.map(value =>
          BranchName.unwrap(value): java.lang.String
        )
      )(_.platformBranchName)
      .optionallyWith(
        platformBranchLifecycleState.map(value =>
          PlatformBranchLifecycleState.unwrap(value): java.lang.String
        )
      )(_.platformBranchLifecycleState)
      .build()
  }
  def asReadOnly: zio.aws.elasticbeanstalk.model.PlatformSummary.ReadOnly =
    zio.aws.elasticbeanstalk.model.PlatformSummary.wrap(buildAwsValue())
}
object PlatformSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.elasticbeanstalk.model.PlatformSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.elasticbeanstalk.model.PlatformSummary =
      zio.aws.elasticbeanstalk.model.PlatformSummary(
        platformArn.map(value => value),
        platformOwner.map(value => value),
        platformStatus.map(value => value),
        platformCategory.map(value => value),
        operatingSystemName.map(value => value),
        operatingSystemVersion.map(value => value),
        supportedTierList.map(value => value),
        supportedAddonList.map(value => value),
        platformLifecycleState.map(value => value),
        platformVersion.map(value => value),
        platformBranchName.map(value => value),
        platformBranchLifecycleState.map(value => value)
      )
    def platformArn: Optional[PlatformArn]
    def platformOwner: Optional[PlatformOwner]
    def platformStatus: Optional[zio.aws.elasticbeanstalk.model.PlatformStatus]
    def platformCategory: Optional[PlatformCategory]
    def operatingSystemName: Optional[OperatingSystemName]
    def operatingSystemVersion: Optional[OperatingSystemVersion]
    def supportedTierList: Optional[List[SupportedTier]]
    def supportedAddonList: Optional[List[SupportedAddon]]
    def platformLifecycleState: Optional[PlatformLifecycleState]
    def platformVersion: Optional[PlatformVersion]
    def platformBranchName: Optional[BranchName]
    def platformBranchLifecycleState: Optional[PlatformBranchLifecycleState]
    def getPlatformArn: ZIO[Any, AwsError, PlatformArn] =
      AwsError.unwrapOptionField("platformArn", platformArn)
    def getPlatformOwner: ZIO[Any, AwsError, PlatformOwner] =
      AwsError.unwrapOptionField("platformOwner", platformOwner)
    def getPlatformStatus
        : ZIO[Any, AwsError, zio.aws.elasticbeanstalk.model.PlatformStatus] =
      AwsError.unwrapOptionField("platformStatus", platformStatus)
    def getPlatformCategory: ZIO[Any, AwsError, PlatformCategory] =
      AwsError.unwrapOptionField("platformCategory", platformCategory)
    def getOperatingSystemName: ZIO[Any, AwsError, OperatingSystemName] =
      AwsError.unwrapOptionField("operatingSystemName", operatingSystemName)
    def getOperatingSystemVersion: ZIO[Any, AwsError, OperatingSystemVersion] =
      AwsError.unwrapOptionField(
        "operatingSystemVersion",
        operatingSystemVersion
      )
    def getSupportedTierList: ZIO[Any, AwsError, List[SupportedTier]] =
      AwsError.unwrapOptionField("supportedTierList", supportedTierList)
    def getSupportedAddonList: ZIO[Any, AwsError, List[SupportedAddon]] =
      AwsError.unwrapOptionField("supportedAddonList", supportedAddonList)
    def getPlatformLifecycleState: ZIO[Any, AwsError, PlatformLifecycleState] =
      AwsError.unwrapOptionField(
        "platformLifecycleState",
        platformLifecycleState
      )
    def getPlatformVersion: ZIO[Any, AwsError, PlatformVersion] =
      AwsError.unwrapOptionField("platformVersion", platformVersion)
    def getPlatformBranchName: ZIO[Any, AwsError, BranchName] =
      AwsError.unwrapOptionField("platformBranchName", platformBranchName)
    def getPlatformBranchLifecycleState
        : ZIO[Any, AwsError, PlatformBranchLifecycleState] =
      AwsError.unwrapOptionField(
        "platformBranchLifecycleState",
        platformBranchLifecycleState
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.PlatformSummary
  ) extends zio.aws.elasticbeanstalk.model.PlatformSummary.ReadOnly {
    override val platformArn: Optional[PlatformArn] = zio.aws.core.internal
      .optionalFromNullable(impl.platformArn())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformArn(value)
      )
    override val platformOwner: Optional[PlatformOwner] = zio.aws.core.internal
      .optionalFromNullable(impl.platformOwner())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives.PlatformOwner(value)
      )
    override val platformStatus
        : Optional[zio.aws.elasticbeanstalk.model.PlatformStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformStatus())
        .map(value => zio.aws.elasticbeanstalk.model.PlatformStatus.wrap(value))
    override val platformCategory: Optional[PlatformCategory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformCategory())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.PlatformCategory(value)
        )
    override val operatingSystemName: Optional[OperatingSystemName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operatingSystemName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.OperatingSystemName(value)
        )
    override val operatingSystemVersion: Optional[OperatingSystemVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.operatingSystemVersion())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives
            .OperatingSystemVersion(value)
        )
    override val supportedTierList: Optional[List[SupportedTier]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedTierList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.primitives.SupportedTier(item)
          }.toList
        )
    override val supportedAddonList: Optional[List[SupportedAddon]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.supportedAddonList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.elasticbeanstalk.model.primitives.SupportedAddon(item)
          }.toList
        )
    override val platformLifecycleState: Optional[PlatformLifecycleState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformLifecycleState())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives
            .PlatformLifecycleState(value)
        )
    override val platformVersion: Optional[PlatformVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformVersion())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.PlatformVersion(value)
        )
    override val platformBranchName: Optional[BranchName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.platformBranchName())
        .map(value =>
          zio.aws.elasticbeanstalk.model.primitives.BranchName(value)
        )
    override val platformBranchLifecycleState
        : Optional[PlatformBranchLifecycleState] = zio.aws.core.internal
      .optionalFromNullable(impl.platformBranchLifecycleState())
      .map(value =>
        zio.aws.elasticbeanstalk.model.primitives
          .PlatformBranchLifecycleState(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.elasticbeanstalk.model.PlatformSummary
  ): zio.aws.elasticbeanstalk.model.PlatformSummary.ReadOnly = new Wrapper(impl)
}
